package io.strimzi.api.kafka.model.status;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KafkaBridgeStatusFluentImpl<A extends KafkaBridgeStatusFluent<A>> extends StatusFluentImpl<A> implements KafkaBridgeStatusFluent<A> {

    private String url;
    private int replicas;
    private String labelSelector;

    public KafkaBridgeStatusFluentImpl() {
    }

    public KafkaBridgeStatusFluentImpl(KafkaBridgeStatus instance) {
        this.withUrl(instance.getUrl());
        
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url=url; return (A) this;
    }

    public Boolean hasUrl() {
        return this.url != null;
    }

    public A withNewUrl(StringBuilder arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(int[] arg1,int arg2,int arg3) {
        return (A)withUrl(new String(arg1, arg2, arg3));
    }

    public A withNewUrl(char[] arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(byte[] arg1,int arg2) {
        return (A)withUrl(new String(arg1, arg2));
    }

    public A withNewUrl(byte[] arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(char[] arg1,int arg2,int arg3) {
        return (A)withUrl(new String(arg1, arg2, arg3));
    }

    public A withNewUrl(byte[] arg1,int arg2,int arg3) {
        return (A)withUrl(new String(arg1, arg2, arg3));
    }

    public A withNewUrl(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUrl(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUrl(String arg1) {
        return (A)withUrl(new String(arg1));
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return true;
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public A withLabelSelector(String labelSelector) {
        this.labelSelector=labelSelector; return (A) this;
    }

    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public A withNewLabelSelector(StringBuilder arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(int[] arg1,int arg2,int arg3) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3));
    }

    public A withNewLabelSelector(char[] arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(StringBuffer arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(byte[] arg1,int arg2) {
        return (A)withLabelSelector(new String(arg1, arg2));
    }

    public A withNewLabelSelector(byte[] arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(char[] arg1,int arg2,int arg3) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3));
    }

    public A withNewLabelSelector(byte[] arg1,int arg2,int arg3) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3));
    }

    public A withNewLabelSelector(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLabelSelector(String arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeStatusFluentImpl that = (KafkaBridgeStatusFluentImpl) o;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        if (replicas != that.replicas) return false;
        if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(url,  replicas,  labelSelector,  super.hashCode());
    }

}
