package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectS2IStatusBuilder extends KafkaConnectS2IStatusFluentImpl<KafkaConnectS2IStatusBuilder> implements VisitableBuilder<KafkaConnectS2IStatus,KafkaConnectS2IStatusBuilder> {

    KafkaConnectS2IStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectS2IStatusBuilder() {
        this(true);
    }

    public KafkaConnectS2IStatusBuilder(Boolean validationEnabled) {
        this(new KafkaConnectS2IStatus(), validationEnabled);
    }

    public KafkaConnectS2IStatusBuilder(KafkaConnectS2IStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaConnectS2IStatusBuilder(KafkaConnectS2IStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaConnectS2IStatus(), validationEnabled);
    }

    public KafkaConnectS2IStatusBuilder(KafkaConnectS2IStatusFluent<?> fluent,KafkaConnectS2IStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectS2IStatusBuilder(KafkaConnectS2IStatusFluent<?> fluent,KafkaConnectS2IStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBuildConfigName(instance.getBuildConfigName());
        
        fluent.withUrl(instance.getUrl());
        
        fluent.withConnectorPlugins(instance.getConnectorPlugins());
        
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withLabelSelector(instance.getLabelSelector());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectS2IStatusBuilder(KafkaConnectS2IStatus instance) {
        this(instance,true);
    }

    public KafkaConnectS2IStatusBuilder(KafkaConnectS2IStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBuildConfigName(instance.getBuildConfigName());
        
        this.withUrl(instance.getUrl());
        
        this.withConnectorPlugins(instance.getConnectorPlugins());
        
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectS2IStatus build() {
        KafkaConnectS2IStatus buildable = new KafkaConnectS2IStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setUrl(fluent.getUrl());
        buildable.setConnectorPlugins(fluent.getConnectorPlugins());
        buildable.setReplicas(fluent.getReplicas());
        buildable.setLabelSelector(fluent.getLabelSelector());
        buildable.setBuildConfigName(fluent.getBuildConfigName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectS2IStatusBuilder that = (KafkaConnectS2IStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
