package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder;
import io.strimzi.api.kafka.model.connect.ConnectorPluginFluent;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.connect.ConnectorPlugin;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface KafkaConnectStatusFluent<A extends KafkaConnectStatusFluent<A>> extends StatusFluent<A> {


    public String getUrl();
    public A withUrl(String url);
    public Boolean hasUrl();
    public A withNewUrl(StringBuilder arg1);
    public A withNewUrl(int[] arg1,int arg2,int arg3);
    public A withNewUrl(char[] arg1);
    public A withNewUrl(StringBuffer arg1);
    public A withNewUrl(byte[] arg1,int arg2);
    public A withNewUrl(byte[] arg1);
    public A withNewUrl(char[] arg1,int arg2,int arg3);
    public A withNewUrl(byte[] arg1,int arg2,int arg3);
    public A withNewUrl(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewUrl(String arg1);
    public A addToConnectorPlugins(int index,ConnectorPlugin item);
    public A setToConnectorPlugins(int index,ConnectorPlugin item);
    public A addToConnectorPlugins(ConnectorPlugin... items);
    public A addAllToConnectorPlugins(Collection<ConnectorPlugin> items);
    public A removeFromConnectorPlugins(ConnectorPlugin... items);
    public A removeAllFromConnectorPlugins(Collection<ConnectorPlugin> items);
    public A removeMatchingFromConnectorPlugins(Predicate<ConnectorPluginBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConnectorPlugins instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<ConnectorPlugin> getConnectorPlugins();
    public java.util.List<ConnectorPlugin> buildConnectorPlugins();
    public ConnectorPlugin buildConnectorPlugin(int index);
    public ConnectorPlugin buildFirstConnectorPlugin();
    public ConnectorPlugin buildLastConnectorPlugin();
    public ConnectorPlugin buildMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate);
    public Boolean hasMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate);
    public A withConnectorPlugins(java.util.List<ConnectorPlugin> connectorPlugins);
    public A withConnectorPlugins(ConnectorPlugin... connectorPlugins);
    public Boolean hasConnectorPlugins();
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> addNewConnectorPlugin();
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> addNewConnectorPluginLike(ConnectorPlugin item);
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> setNewConnectorPluginLike(int index,ConnectorPlugin item);
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editConnectorPlugin(int index);
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editFirstConnectorPlugin();
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editLastConnectorPlugin();
    public KafkaConnectStatusFluent.ConnectorPluginsNested<A> editMatchingConnectorPlugin(Predicate<ConnectorPluginBuilder> predicate);
    public int getReplicas();
    public A withReplicas(int replicas);
    public Boolean hasReplicas();
    public String getLabelSelector();
    public A withLabelSelector(String labelSelector);
    public Boolean hasLabelSelector();
    public A withNewLabelSelector(StringBuilder arg1);
    public A withNewLabelSelector(int[] arg1,int arg2,int arg3);
    public A withNewLabelSelector(char[] arg1);
    public A withNewLabelSelector(StringBuffer arg1);
    public A withNewLabelSelector(byte[] arg1,int arg2);
    public A withNewLabelSelector(byte[] arg1);
    public A withNewLabelSelector(char[] arg1,int arg2,int arg3);
    public A withNewLabelSelector(byte[] arg1,int arg2,int arg3);
    public A withNewLabelSelector(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLabelSelector(String arg1);
    public interface ConnectorPluginsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConnectorPluginFluent<KafkaConnectStatusFluent.ConnectorPluginsNested<N>> {

            public N and();
            public N endConnectorPlugin();    }


}
