package io.strimzi.api.kafka.model.status;

import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaConnectorStatusFluent<A extends KafkaConnectorStatusFluent<A>> extends StatusFluent<A> {


    public A addToConnectorStatus(String key,Object value);
    public A addToConnectorStatus(Map<String,Object> map);
    public A removeFromConnectorStatus(String key);
    public A removeFromConnectorStatus(Map<String,Object> map);
    public Map<String,Object> getConnectorStatus();
    public <K extends Object,V extends Object>A withConnectorStatus(Map<String,Object> connectorStatus);
    public Boolean hasConnectorStatus();
    public int getTasksMax();
    public A withTasksMax(int tasksMax);
    public Boolean hasTasksMax();
    public A addToTopics(int index,String item);
    public A setToTopics(int index,String item);
    public A addToTopics(String... items);
    public A addAllToTopics(Collection<String> items);
    public A removeFromTopics(String... items);
    public A removeAllFromTopics(Collection<String> items);
    public java.util.List<String> getTopics();
    public String getTopic(int index);
    public String getFirstTopic();
    public String getLastTopic();
    public String getMatchingTopic(Predicate<String> predicate);
    public Boolean hasMatchingTopic(Predicate<String> predicate);
    public A withTopics(java.util.List<String> topics);
    public A withTopics(String... topics);
    public Boolean hasTopics();
    public A addNewTopic(StringBuilder arg1);
    public A addNewTopic(int[] arg1,int arg2,int arg3);
    public A addNewTopic(char[] arg1);
    public A addNewTopic(StringBuffer arg1);
    public A addNewTopic(byte[] arg1,int arg2);
    public A addNewTopic(byte[] arg1);
    public A addNewTopic(char[] arg1,int arg2,int arg3);
    public A addNewTopic(byte[] arg1,int arg2,int arg3);
    public A addNewTopic(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewTopic(String arg1);
}
