package io.strimzi.api.kafka.model.status;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KafkaMirrorMakerStatusFluentImpl<A extends KafkaMirrorMakerStatusFluent<A>> extends StatusFluentImpl<A> implements KafkaMirrorMakerStatusFluent<A> {

    private int replicas;
    private String labelSelector;

    public KafkaMirrorMakerStatusFluentImpl() {
    }

    public KafkaMirrorMakerStatusFluentImpl(KafkaMirrorMakerStatus instance) {
        this.withReplicas(instance.getReplicas());
        
        this.withLabelSelector(instance.getLabelSelector());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return true;
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public A withLabelSelector(String labelSelector) {
        this.labelSelector=labelSelector; return (A) this;
    }

    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public A withNewLabelSelector(StringBuilder arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(int[] arg1,int arg2,int arg3) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3));
    }

    public A withNewLabelSelector(char[] arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(StringBuffer arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(byte[] arg1,int arg2) {
        return (A)withLabelSelector(new String(arg1, arg2));
    }

    public A withNewLabelSelector(byte[] arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public A withNewLabelSelector(char[] arg1,int arg2,int arg3) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3));
    }

    public A withNewLabelSelector(byte[] arg1,int arg2,int arg3) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3));
    }

    public A withNewLabelSelector(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLabelSelector(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLabelSelector(String arg1) {
        return (A)withLabelSelector(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerStatusFluentImpl that = (KafkaMirrorMakerStatusFluentImpl) o;
        if (replicas != that.replicas) return false;
        if (labelSelector != null ? !labelSelector.equals(that.labelSelector) :that.labelSelector != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(replicas,  labelSelector,  super.hashCode());
    }

}
