package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaStatusBuilder extends KafkaStatusFluentImpl<KafkaStatusBuilder> implements VisitableBuilder<KafkaStatus,KafkaStatusBuilder> {

    KafkaStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaStatusBuilder() {
        this(true);
    }

    public KafkaStatusBuilder(Boolean validationEnabled) {
        this(new KafkaStatus(), validationEnabled);
    }

    public KafkaStatusBuilder(KafkaStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaStatusBuilder(KafkaStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaStatus(), validationEnabled);
    }

    public KafkaStatusBuilder(KafkaStatusFluent<?> fluent,KafkaStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaStatusBuilder(KafkaStatusFluent<?> fluent,KafkaStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withListeners(instance.getListeners());
        
        fluent.withClusterId(instance.getClusterId());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaStatusBuilder(KafkaStatus instance) {
        this(instance,true);
    }

    public KafkaStatusBuilder(KafkaStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withListeners(instance.getListeners());
        
        this.withClusterId(instance.getClusterId());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaStatus build() {
        KafkaStatus buildable = new KafkaStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setListeners(fluent.getListeners());
        buildable.setClusterId(fluent.getClusterId());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaStatusBuilder that = (KafkaStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
