package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class KafkaStatusFluentImpl<A extends KafkaStatusFluent<A>> extends StatusFluentImpl<A> implements KafkaStatusFluent<A> {

    private java.util.List<ListenerStatusBuilder> listeners;
    private String clusterId;

    public KafkaStatusFluentImpl() {
    }

    public KafkaStatusFluentImpl(KafkaStatus instance) {
        this.withListeners(instance.getListeners());
        
        this.withClusterId(instance.getClusterId());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public A addToListeners(int index,ListenerStatus item) {
        if (this.listeners == null) {this.listeners = new ArrayList<ListenerStatusBuilder>();}
        ListenerStatusBuilder builder = new ListenerStatusBuilder(item);_visitables.get("listeners").add(index >= 0 ? index : _visitables.get("listeners").size(), builder);this.listeners.add(index >= 0 ? index : listeners.size(), builder); return (A)this;
    }

    public A setToListeners(int index,ListenerStatus item) {
        if (this.listeners == null) {this.listeners = new ArrayList<ListenerStatusBuilder>();}
        ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("listeners").size()) { _visitables.get("listeners").add(builder); } else { _visitables.get("listeners").set(index, builder);}
        if (index < 0 || index >= listeners.size()) { listeners.add(builder); } else { listeners.set(index, builder);}
         return (A)this;
    }

    public A addToListeners(ListenerStatus... items) {
        if (this.listeners == null) {this.listeners = new ArrayList<ListenerStatusBuilder>();}
        for (ListenerStatus item : items) {ListenerStatusBuilder builder = new ListenerStatusBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
    }

    public A addAllToListeners(Collection<ListenerStatus> items) {
        if (this.listeners == null) {this.listeners = new ArrayList<ListenerStatusBuilder>();}
        for (ListenerStatus item : items) {ListenerStatusBuilder builder = new ListenerStatusBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
    }

    public A removeFromListeners(ListenerStatus... items) {
        for (ListenerStatus item : items) {ListenerStatusBuilder builder = new ListenerStatusBuilder(item);_visitables.get("listeners").remove(builder);if (this.listeners != null) {this.listeners.remove(builder);}} return (A)this;
    }

    public A removeAllFromListeners(Collection<ListenerStatus> items) {
        for (ListenerStatus item : items) {ListenerStatusBuilder builder = new ListenerStatusBuilder(item);_visitables.get("listeners").remove(builder);if (this.listeners != null) {this.listeners.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromListeners(Predicate<ListenerStatusBuilder> predicate) {
        if (listeners == null) return (A) this;
        final Iterator<ListenerStatusBuilder> each = listeners.iterator();
        final List visitables = _visitables.get("listeners");
        while (each.hasNext()) {
          ListenerStatusBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildListeners instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<ListenerStatus> getListeners() {
        return build(listeners);
    }

    public java.util.List<ListenerStatus> buildListeners() {
        return build(listeners);
    }

    public ListenerStatus buildListener(int index) {
        return this.listeners.get(index).build();
    }

    public ListenerStatus buildFirstListener() {
        return this.listeners.get(0).build();
    }

    public ListenerStatus buildLastListener() {
        return this.listeners.get(listeners.size() - 1).build();
    }

    public ListenerStatus buildMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        for (ListenerStatusBuilder item: listeners) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        for (ListenerStatusBuilder item: listeners) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withListeners(java.util.List<ListenerStatus> listeners) {
        if (this.listeners != null) { _visitables.get("listeners").removeAll(this.listeners);}
        if (listeners != null) {this.listeners = new ArrayList<ListenerStatusBuilder>(); for (ListenerStatus item : listeners){this.addToListeners(item);}} else { this.listeners = null;} return (A) this;
    }

    public A withListeners(ListenerStatus... listeners) {
        if (this.listeners != null) {this.listeners.clear();}
        if (listeners != null) {for (ListenerStatus item :listeners){ this.addToListeners(item);}} return (A) this;
    }

    public Boolean hasListeners() {
        return listeners != null && !listeners.isEmpty();
    }

    public KafkaStatusFluent.ListenersNested<A> addNewListener() {
        return new ListenersNestedImpl();
    }

    public KafkaStatusFluent.ListenersNested<A> addNewListenerLike(ListenerStatus item) {
        return new ListenersNestedImpl(-1, item);
    }

    public KafkaStatusFluent.ListenersNested<A> setNewListenerLike(int index,ListenerStatus item) {
        return new ListenersNestedImpl(index, item);
    }

    public KafkaStatusFluent.ListenersNested<A> editListener(int index) {
        if (listeners.size() <= index) throw new RuntimeException("Can't edit listeners. Index exceeds size.");
        return setNewListenerLike(index, buildListener(index));
    }

    public KafkaStatusFluent.ListenersNested<A> editFirstListener() {
        if (listeners.size() == 0) throw new RuntimeException("Can't edit first listeners. The list is empty.");
        return setNewListenerLike(0, buildListener(0));
    }

    public KafkaStatusFluent.ListenersNested<A> editLastListener() {
        int index = listeners.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last listeners. The list is empty.");
        return setNewListenerLike(index, buildListener(index));
    }

    public KafkaStatusFluent.ListenersNested<A> editMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<listeners.size();i++) { 
        if (predicate.test(listeners.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching listeners. No match found.");
        return setNewListenerLike(index, buildListener(index));
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public A withClusterId(String clusterId) {
        this.clusterId=clusterId; return (A) this;
    }

    public Boolean hasClusterId() {
        return this.clusterId != null;
    }

    public A withNewClusterId(StringBuilder arg1) {
        return (A)withClusterId(new String(arg1));
    }

    public A withNewClusterId(int[] arg1,int arg2,int arg3) {
        return (A)withClusterId(new String(arg1, arg2, arg3));
    }

    public A withNewClusterId(char[] arg1) {
        return (A)withClusterId(new String(arg1));
    }

    public A withNewClusterId(StringBuffer arg1) {
        return (A)withClusterId(new String(arg1));
    }

    public A withNewClusterId(byte[] arg1,int arg2) {
        return (A)withClusterId(new String(arg1, arg2));
    }

    public A withNewClusterId(byte[] arg1) {
        return (A)withClusterId(new String(arg1));
    }

    public A withNewClusterId(char[] arg1,int arg2,int arg3) {
        return (A)withClusterId(new String(arg1, arg2, arg3));
    }

    public A withNewClusterId(byte[] arg1,int arg2,int arg3) {
        return (A)withClusterId(new String(arg1, arg2, arg3));
    }

    public A withNewClusterId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withClusterId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewClusterId(String arg1) {
        return (A)withClusterId(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaStatusFluentImpl that = (KafkaStatusFluentImpl) o;
        if (listeners != null ? !listeners.equals(that.listeners) :that.listeners != null) return false;
        if (clusterId != null ? !clusterId.equals(that.clusterId) :that.clusterId != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(listeners,  clusterId,  super.hashCode());
    }

    public class ListenersNestedImpl<N> extends ListenerStatusFluentImpl<KafkaStatusFluent.ListenersNested<N>> implements KafkaStatusFluent.ListenersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ListenerStatusBuilder builder;
        private final int index;

            ListenersNestedImpl(int index,ListenerStatus item) {
                this.index = index;
                this.builder = new ListenerStatusBuilder(this, item);
                        
            }

            ListenersNestedImpl() {
                this.index = -1;
                this.builder = new ListenerStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaStatusFluentImpl.this.setToListeners(index,builder.build());
            }

            public N endListener() {
                return and();
            }
    }


}
