package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaTopicStatusBuilder extends KafkaTopicStatusFluentImpl<KafkaTopicStatusBuilder> implements VisitableBuilder<KafkaTopicStatus,KafkaTopicStatusBuilder> {

    KafkaTopicStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaTopicStatusBuilder() {
        this(true);
    }

    public KafkaTopicStatusBuilder(Boolean validationEnabled) {
        this(new KafkaTopicStatus(), validationEnabled);
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaTopicStatus(), validationEnabled);
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent,KafkaTopicStatus instance) {
        this(fluent, instance, true);
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatusFluent<?> fluent,KafkaTopicStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTopicName(instance.getTopicName());
        
        fluent.withConditions(instance.getConditions());
        
        fluent.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatus instance) {
        this(instance,true);
    }

    public KafkaTopicStatusBuilder(KafkaTopicStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTopicName(instance.getTopicName());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaTopicStatus build() {
        KafkaTopicStatus buildable = new KafkaTopicStatus();
        buildable.setConditions(fluent.getConditions());
        buildable.setObservedGeneration(fluent.getObservedGeneration());
        buildable.setTopicName(fluent.getTopicName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaTopicStatusBuilder that = (KafkaTopicStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
