package io.strimzi.api.kafka.model.status;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KafkaTopicStatusFluentImpl<A extends KafkaTopicStatusFluent<A>> extends StatusFluentImpl<A> implements KafkaTopicStatusFluent<A> {

    private String topicName;

    public KafkaTopicStatusFluentImpl() {
    }

    public KafkaTopicStatusFluentImpl(KafkaTopicStatus instance) {
        this.withTopicName(instance.getTopicName());
        
        this.withConditions(instance.getConditions());
        
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    public String getTopicName() {
        return this.topicName;
    }

    public A withTopicName(String topicName) {
        this.topicName=topicName; return (A) this;
    }

    public Boolean hasTopicName() {
        return this.topicName != null;
    }

    public A withNewTopicName(StringBuilder arg1) {
        return (A)withTopicName(new String(arg1));
    }

    public A withNewTopicName(int[] arg1,int arg2,int arg3) {
        return (A)withTopicName(new String(arg1, arg2, arg3));
    }

    public A withNewTopicName(char[] arg1) {
        return (A)withTopicName(new String(arg1));
    }

    public A withNewTopicName(StringBuffer arg1) {
        return (A)withTopicName(new String(arg1));
    }

    public A withNewTopicName(byte[] arg1,int arg2) {
        return (A)withTopicName(new String(arg1, arg2));
    }

    public A withNewTopicName(byte[] arg1) {
        return (A)withTopicName(new String(arg1));
    }

    public A withNewTopicName(char[] arg1,int arg2,int arg3) {
        return (A)withTopicName(new String(arg1, arg2, arg3));
    }

    public A withNewTopicName(byte[] arg1,int arg2,int arg3) {
        return (A)withTopicName(new String(arg1, arg2, arg3));
    }

    public A withNewTopicName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTopicName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTopicName(String arg1) {
        return (A)withTopicName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaTopicStatusFluentImpl that = (KafkaTopicStatusFluentImpl) o;
        if (topicName != null ? !topicName.equals(that.topicName) :that.topicName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(topicName,  super.hashCode());
    }

}
