package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ListenerAddressBuilder extends ListenerAddressFluentImpl<ListenerAddressBuilder> implements VisitableBuilder<ListenerAddress,ListenerAddressBuilder> {

    ListenerAddressFluent<?> fluent;
    Boolean validationEnabled;

    public ListenerAddressBuilder() {
        this(true);
    }

    public ListenerAddressBuilder(Boolean validationEnabled) {
        this(new ListenerAddress(), validationEnabled);
    }

    public ListenerAddressBuilder(ListenerAddressFluent<?> fluent) {
        this(fluent, true);
    }

    public ListenerAddressBuilder(ListenerAddressFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ListenerAddress(), validationEnabled);
    }

    public ListenerAddressBuilder(ListenerAddressFluent<?> fluent,ListenerAddress instance) {
        this(fluent, instance, true);
    }

    public ListenerAddressBuilder(ListenerAddressFluent<?> fluent,ListenerAddress instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHost(instance.getHost());
        
        fluent.withPort(instance.getPort());
        
        this.validationEnabled = validationEnabled; 
    }

    public ListenerAddressBuilder(ListenerAddress instance) {
        this(instance,true);
    }

    public ListenerAddressBuilder(ListenerAddress instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHost(instance.getHost());
        
        this.withPort(instance.getPort());
        
        this.validationEnabled = validationEnabled; 
    }

    public ListenerAddress build() {
        ListenerAddress buildable = new ListenerAddress();
        buildable.setHost(fluent.getHost());
        buildable.setPort(fluent.getPort());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ListenerAddressBuilder that = (ListenerAddressBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
