package io.strimzi.api.kafka.model.status;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ListenerStatusBuilder extends ListenerStatusFluentImpl<ListenerStatusBuilder> implements VisitableBuilder<ListenerStatus,ListenerStatusBuilder> {

    ListenerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ListenerStatusBuilder() {
        this(true);
    }

    public ListenerStatusBuilder(Boolean validationEnabled) {
        this(new ListenerStatus(), validationEnabled);
    }

    public ListenerStatusBuilder(ListenerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ListenerStatusBuilder(ListenerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ListenerStatus(), validationEnabled);
    }

    public ListenerStatusBuilder(ListenerStatusFluent<?> fluent,ListenerStatus instance) {
        this(fluent, instance, true);
    }

    public ListenerStatusBuilder(ListenerStatusFluent<?> fluent,ListenerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withType(instance.getType());
        
        fluent.withAddresses(instance.getAddresses());
        
        fluent.withCertificates(instance.getCertificates());
        
        this.validationEnabled = validationEnabled; 
    }

    public ListenerStatusBuilder(ListenerStatus instance) {
        this(instance,true);
    }

    public ListenerStatusBuilder(ListenerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withType(instance.getType());
        
        this.withAddresses(instance.getAddresses());
        
        this.withCertificates(instance.getCertificates());
        
        this.validationEnabled = validationEnabled; 
    }

    public ListenerStatus build() {
        ListenerStatus buildable = new ListenerStatus();
        buildable.setType(fluent.getType());
        buildable.setAddresses(fluent.getAddresses());
        buildable.setCertificates(fluent.getCertificates());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ListenerStatusBuilder that = (ListenerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
