package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EphemeralStorageBuilder extends EphemeralStorageFluentImpl<EphemeralStorageBuilder> implements VisitableBuilder<EphemeralStorage,EphemeralStorageBuilder> {

    EphemeralStorageFluent<?> fluent;
    Boolean validationEnabled;

    public EphemeralStorageBuilder() {
        this(true);
    }

    public EphemeralStorageBuilder(Boolean validationEnabled) {
        this(new EphemeralStorage(), validationEnabled);
    }

    public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent) {
        this(fluent, true);
    }

    public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EphemeralStorage(), validationEnabled);
    }

    public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent,EphemeralStorage instance) {
        this(fluent, instance, true);
    }

    public EphemeralStorageBuilder(EphemeralStorageFluent<?> fluent,EphemeralStorage instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withId(instance.getId());
        
        fluent.withSizeLimit(instance.getSizeLimit());
        
        this.validationEnabled = validationEnabled; 
    }

    public EphemeralStorageBuilder(EphemeralStorage instance) {
        this(instance,true);
    }

    public EphemeralStorageBuilder(EphemeralStorage instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withId(instance.getId());
        
        this.withSizeLimit(instance.getSizeLimit());
        
        this.validationEnabled = validationEnabled; 
    }

    public EphemeralStorage build() {
        EphemeralStorage buildable = new EphemeralStorage();
        buildable.setId(fluent.getId());
        buildable.setSizeLimit(fluent.getSizeLimit());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EphemeralStorageBuilder that = (EphemeralStorageBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
