package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PersistentClaimStorageOverrideBuilder extends PersistentClaimStorageOverrideFluentImpl<PersistentClaimStorageOverrideBuilder> implements VisitableBuilder<PersistentClaimStorageOverride,PersistentClaimStorageOverrideBuilder> {

    PersistentClaimStorageOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public PersistentClaimStorageOverrideBuilder() {
        this(true);
    }

    public PersistentClaimStorageOverrideBuilder(Boolean validationEnabled) {
        this(new PersistentClaimStorageOverride(), validationEnabled);
    }

    public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverrideFluent<?> fluent) {
        this(fluent, true);
    }

    public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverrideFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PersistentClaimStorageOverride(), validationEnabled);
    }

    public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverrideFluent<?> fluent,PersistentClaimStorageOverride instance) {
        this(fluent, instance, true);
    }

    public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverrideFluent<?> fluent,PersistentClaimStorageOverride instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBroker(instance.getBroker());
        
        fluent.withStorageClass(instance.getStorageClass());
        
        this.validationEnabled = validationEnabled; 
    }

    public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverride instance) {
        this(instance,true);
    }

    public PersistentClaimStorageOverrideBuilder(PersistentClaimStorageOverride instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBroker(instance.getBroker());
        
        this.withStorageClass(instance.getStorageClass());
        
        this.validationEnabled = validationEnabled; 
    }

    public PersistentClaimStorageOverride build() {
        PersistentClaimStorageOverride buildable = new PersistentClaimStorageOverride();
        buildable.setBroker(fluent.getBroker());
        buildable.setStorageClass(fluent.getStorageClass());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PersistentClaimStorageOverrideBuilder that = (PersistentClaimStorageOverrideBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
