package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.ContainerEnvVar;
import java.lang.String;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.ContainerEnvVarBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.SecurityContext;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;
import io.strimzi.api.kafka.model.ContainerEnvVarFluent;

public interface ContainerTemplateFluent<A extends ContainerTemplateFluent<A>> extends Fluent<A> {


    public A addToEnv(int index,ContainerEnvVar item);
    public A setToEnv(int index,ContainerEnvVar item);
    public A addToEnv(ContainerEnvVar... items);
    public A addAllToEnv(Collection<ContainerEnvVar> items);
    public A removeFromEnv(ContainerEnvVar... items);
    public A removeAllFromEnv(Collection<ContainerEnvVar> items);
    public A removeMatchingFromEnv(Predicate<ContainerEnvVarBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEnv instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<ContainerEnvVar> getEnv();
    public java.util.List<ContainerEnvVar> buildEnv();
    public ContainerEnvVar buildEnv(int index);
    public ContainerEnvVar buildFirstEnv();
    public ContainerEnvVar buildLastEnv();
    public ContainerEnvVar buildMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate);
    public Boolean hasMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate);
    public A withEnv(java.util.List<ContainerEnvVar> env);
    public A withEnv(ContainerEnvVar... env);
    public Boolean hasEnv();
    public ContainerTemplateFluent.EnvNested<A> addNewEnv();
    public ContainerTemplateFluent.EnvNested<A> addNewEnvLike(ContainerEnvVar item);
    public ContainerTemplateFluent.EnvNested<A> setNewEnvLike(int index,ContainerEnvVar item);
    public ContainerTemplateFluent.EnvNested<A> editEnv(int index);
    public ContainerTemplateFluent.EnvNested<A> editFirstEnv();
    public ContainerTemplateFluent.EnvNested<A> editLastEnv();
    public ContainerTemplateFluent.EnvNested<A> editMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate);
    public SecurityContext getSecurityContext();
    public A withSecurityContext(SecurityContext securityContext);
    public Boolean hasSecurityContext();
    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerEnvVarFluent<ContainerTemplateFluent.EnvNested<N>> {

            public N and();
            public N endEnv();    }


}
