package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EntityOperatorTemplateBuilder extends EntityOperatorTemplateFluentImpl<EntityOperatorTemplateBuilder> implements VisitableBuilder<EntityOperatorTemplate,EntityOperatorTemplateBuilder> {

    EntityOperatorTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public EntityOperatorTemplateBuilder() {
        this(true);
    }

    public EntityOperatorTemplateBuilder(Boolean validationEnabled) {
        this(new EntityOperatorTemplate(), validationEnabled);
    }

    public EntityOperatorTemplateBuilder(EntityOperatorTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public EntityOperatorTemplateBuilder(EntityOperatorTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EntityOperatorTemplate(), validationEnabled);
    }

    public EntityOperatorTemplateBuilder(EntityOperatorTemplateFluent<?> fluent,EntityOperatorTemplate instance) {
        this(fluent, instance, true);
    }

    public EntityOperatorTemplateBuilder(EntityOperatorTemplateFluent<?> fluent,EntityOperatorTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withTopicOperatorContainer(instance.getTopicOperatorContainer());
        
        fluent.withUserOperatorContainer(instance.getUserOperatorContainer());
        
        fluent.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.validationEnabled = validationEnabled; 
    }

    public EntityOperatorTemplateBuilder(EntityOperatorTemplate instance) {
        this(instance,true);
    }

    public EntityOperatorTemplateBuilder(EntityOperatorTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withTopicOperatorContainer(instance.getTopicOperatorContainer());
        
        this.withUserOperatorContainer(instance.getUserOperatorContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.validationEnabled = validationEnabled; 
    }

    public EntityOperatorTemplate build() {
        EntityOperatorTemplate buildable = new EntityOperatorTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setTopicOperatorContainer(fluent.getTopicOperatorContainer());
        buildable.setUserOperatorContainer(fluent.getUserOperatorContainer());
        buildable.setTlsSidecarContainer(fluent.getTlsSidecarContainer());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EntityOperatorTemplateBuilder that = (EntityOperatorTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
