package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class EntityOperatorTemplateFluentImpl<A extends EntityOperatorTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EntityOperatorTemplateFluent<A> {

    private ResourceTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private ContainerTemplateBuilder topicOperatorContainer;
    private ContainerTemplateBuilder userOperatorContainer;
    private ContainerTemplateBuilder tlsSidecarContainer;

    public EntityOperatorTemplateFluentImpl() {
    }

    public EntityOperatorTemplateFluentImpl(EntityOperatorTemplate instance) {
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withTopicOperatorContainer(instance.getTopicOperatorContainer());
        
        this.withUserOperatorContainer(instance.getUserOperatorContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
    }

    
/**
 * This method has been deprecated, please use method buildDeployment instead.
 * @return The buildable object.
 */
@Deprecated public ResourceTemplate getDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public ResourceTemplate buildDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(ResourceTemplate deployment) {
        _visitables.get("deployment").remove(this.deployment);
        if (deployment!=null){ this.deployment= new ResourceTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public Boolean hasDeployment() {
        return this.deployment != null;
    }

    public EntityOperatorTemplateFluent.DeploymentNested<A> withNewDeployment() {
        return new DeploymentNestedImpl();
    }

    public EntityOperatorTemplateFluent.DeploymentNested<A> withNewDeploymentLike(ResourceTemplate item) {
        return new DeploymentNestedImpl(item);
    }

    public EntityOperatorTemplateFluent.DeploymentNested<A> editDeployment() {
        return withNewDeploymentLike(getDeployment());
    }

    public EntityOperatorTemplateFluent.DeploymentNested<A> editOrNewDeployment() {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new ResourceTemplateBuilder().build());
    }

    public EntityOperatorTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(ResourceTemplate item) {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPod instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public Boolean hasPod() {
        return this.pod != null;
    }

    public EntityOperatorTemplateFluent.PodNested<A> withNewPod() {
        return new PodNestedImpl();
    }

    public EntityOperatorTemplateFluent.PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNestedImpl(item);
    }

    public EntityOperatorTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public EntityOperatorTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new PodTemplateBuilder().build());
    }

    public EntityOperatorTemplateFluent.PodNested<A> editOrNewPodLike(PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTopicOperatorContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getTopicOperatorContainer() {
        return this.topicOperatorContainer!=null?this.topicOperatorContainer.build():null;
    }

    public ContainerTemplate buildTopicOperatorContainer() {
        return this.topicOperatorContainer!=null?this.topicOperatorContainer.build():null;
    }

    public A withTopicOperatorContainer(ContainerTemplate topicOperatorContainer) {
        _visitables.get("topicOperatorContainer").remove(this.topicOperatorContainer);
        if (topicOperatorContainer!=null){ this.topicOperatorContainer= new ContainerTemplateBuilder(topicOperatorContainer); _visitables.get("topicOperatorContainer").add(this.topicOperatorContainer);} return (A) this;
    }

    public Boolean hasTopicOperatorContainer() {
        return this.topicOperatorContainer != null;
    }

    public EntityOperatorTemplateFluent.TopicOperatorContainerNested<A> withNewTopicOperatorContainer() {
        return new TopicOperatorContainerNestedImpl();
    }

    public EntityOperatorTemplateFluent.TopicOperatorContainerNested<A> withNewTopicOperatorContainerLike(ContainerTemplate item) {
        return new TopicOperatorContainerNestedImpl(item);
    }

    public EntityOperatorTemplateFluent.TopicOperatorContainerNested<A> editTopicOperatorContainer() {
        return withNewTopicOperatorContainerLike(getTopicOperatorContainer());
    }

    public EntityOperatorTemplateFluent.TopicOperatorContainerNested<A> editOrNewTopicOperatorContainer() {
        return withNewTopicOperatorContainerLike(getTopicOperatorContainer() != null ? getTopicOperatorContainer(): new ContainerTemplateBuilder().build());
    }

    public EntityOperatorTemplateFluent.TopicOperatorContainerNested<A> editOrNewTopicOperatorContainerLike(ContainerTemplate item) {
        return withNewTopicOperatorContainerLike(getTopicOperatorContainer() != null ? getTopicOperatorContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildUserOperatorContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getUserOperatorContainer() {
        return this.userOperatorContainer!=null?this.userOperatorContainer.build():null;
    }

    public ContainerTemplate buildUserOperatorContainer() {
        return this.userOperatorContainer!=null?this.userOperatorContainer.build():null;
    }

    public A withUserOperatorContainer(ContainerTemplate userOperatorContainer) {
        _visitables.get("userOperatorContainer").remove(this.userOperatorContainer);
        if (userOperatorContainer!=null){ this.userOperatorContainer= new ContainerTemplateBuilder(userOperatorContainer); _visitables.get("userOperatorContainer").add(this.userOperatorContainer);} return (A) this;
    }

    public Boolean hasUserOperatorContainer() {
        return this.userOperatorContainer != null;
    }

    public EntityOperatorTemplateFluent.UserOperatorContainerNested<A> withNewUserOperatorContainer() {
        return new UserOperatorContainerNestedImpl();
    }

    public EntityOperatorTemplateFluent.UserOperatorContainerNested<A> withNewUserOperatorContainerLike(ContainerTemplate item) {
        return new UserOperatorContainerNestedImpl(item);
    }

    public EntityOperatorTemplateFluent.UserOperatorContainerNested<A> editUserOperatorContainer() {
        return withNewUserOperatorContainerLike(getUserOperatorContainer());
    }

    public EntityOperatorTemplateFluent.UserOperatorContainerNested<A> editOrNewUserOperatorContainer() {
        return withNewUserOperatorContainerLike(getUserOperatorContainer() != null ? getUserOperatorContainer(): new ContainerTemplateBuilder().build());
    }

    public EntityOperatorTemplateFluent.UserOperatorContainerNested<A> editOrNewUserOperatorContainerLike(ContainerTemplate item) {
        return withNewUserOperatorContainerLike(getUserOperatorContainer() != null ? getUserOperatorContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsSidecarContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerTemplate getTlsSidecarContainer() {
        return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public ContainerTemplate buildTlsSidecarContainer() {
        return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public A withTlsSidecarContainer(ContainerTemplate tlsSidecarContainer) {
        _visitables.get("tlsSidecarContainer").remove(this.tlsSidecarContainer);
        if (tlsSidecarContainer!=null){ this.tlsSidecarContainer= new ContainerTemplateBuilder(tlsSidecarContainer); _visitables.get("tlsSidecarContainer").add(this.tlsSidecarContainer);} return (A) this;
    }

    public Boolean hasTlsSidecarContainer() {
        return this.tlsSidecarContainer != null;
    }

    public EntityOperatorTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainer() {
        return new TlsSidecarContainerNestedImpl();
    }

    public EntityOperatorTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainerLike(ContainerTemplate item) {
        return new TlsSidecarContainerNestedImpl(item);
    }

    public EntityOperatorTemplateFluent.TlsSidecarContainerNested<A> editTlsSidecarContainer() {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer());
    }

    public EntityOperatorTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainer() {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): new ContainerTemplateBuilder().build());
    }

    public EntityOperatorTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainerLike(ContainerTemplate item) {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EntityOperatorTemplateFluentImpl that = (EntityOperatorTemplateFluentImpl) o;
        if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (topicOperatorContainer != null ? !topicOperatorContainer.equals(that.topicOperatorContainer) :that.topicOperatorContainer != null) return false;
        if (userOperatorContainer != null ? !userOperatorContainer.equals(that.userOperatorContainer) :that.userOperatorContainer != null) return false;
        if (tlsSidecarContainer != null ? !tlsSidecarContainer.equals(that.tlsSidecarContainer) :that.tlsSidecarContainer != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployment,  pod,  topicOperatorContainer,  userOperatorContainer,  tlsSidecarContainer,  super.hashCode());
    }

    public class DeploymentNestedImpl<N> extends ResourceTemplateFluentImpl<EntityOperatorTemplateFluent.DeploymentNested<N>> implements EntityOperatorTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceTemplateBuilder builder;

            DeploymentNestedImpl(ResourceTemplate item) {
                this.builder = new ResourceTemplateBuilder(this, item);
                        
            }

            DeploymentNestedImpl() {
                this.builder = new ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withDeployment(builder.build());
            }

            public N endDeployment() {
                return and();
            }
    }


    public class PodNestedImpl<N> extends PodTemplateFluentImpl<EntityOperatorTemplateFluent.PodNested<N>> implements EntityOperatorTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateBuilder builder;

            PodNestedImpl(PodTemplate item) {
                this.builder = new PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


    public class TopicOperatorContainerNestedImpl<N> extends ContainerTemplateFluentImpl<EntityOperatorTemplateFluent.TopicOperatorContainerNested<N>> implements EntityOperatorTemplateFluent.TopicOperatorContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerTemplateBuilder builder;

            TopicOperatorContainerNestedImpl(ContainerTemplate item) {
                this.builder = new ContainerTemplateBuilder(this, item);
                        
            }

            TopicOperatorContainerNestedImpl() {
                this.builder = new ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withTopicOperatorContainer(builder.build());
            }

            public N endTopicOperatorContainer() {
                return and();
            }
    }


    public class UserOperatorContainerNestedImpl<N> extends ContainerTemplateFluentImpl<EntityOperatorTemplateFluent.UserOperatorContainerNested<N>> implements EntityOperatorTemplateFluent.UserOperatorContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerTemplateBuilder builder;

            UserOperatorContainerNestedImpl(ContainerTemplate item) {
                this.builder = new ContainerTemplateBuilder(this, item);
                        
            }

            UserOperatorContainerNestedImpl() {
                this.builder = new ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withUserOperatorContainer(builder.build());
            }

            public N endUserOperatorContainer() {
                return and();
            }
    }


    public class TlsSidecarContainerNestedImpl<N> extends ContainerTemplateFluentImpl<EntityOperatorTemplateFluent.TlsSidecarContainerNested<N>> implements EntityOperatorTemplateFluent.TlsSidecarContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerTemplateBuilder builder;

            TlsSidecarContainerNestedImpl(ContainerTemplate item) {
                this.builder = new ContainerTemplateBuilder(this, item);
                        
            }

            TlsSidecarContainerNestedImpl() {
                this.builder = new ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withTlsSidecarContainer(builder.build());
            }

            public N endTlsSidecarContainer() {
                return and();
            }
    }


}
