package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InternalServiceTemplateBuilder extends InternalServiceTemplateFluentImpl<InternalServiceTemplateBuilder> implements VisitableBuilder<InternalServiceTemplate,InternalServiceTemplateBuilder> {

    InternalServiceTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public InternalServiceTemplateBuilder() {
        this(true);
    }

    public InternalServiceTemplateBuilder(Boolean validationEnabled) {
        this(new InternalServiceTemplate(), validationEnabled);
    }

    public InternalServiceTemplateBuilder(InternalServiceTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public InternalServiceTemplateBuilder(InternalServiceTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new InternalServiceTemplate(), validationEnabled);
    }

    public InternalServiceTemplateBuilder(InternalServiceTemplateFluent<?> fluent,InternalServiceTemplate instance) {
        this(fluent, instance, true);
    }

    public InternalServiceTemplateBuilder(InternalServiceTemplateFluent<?> fluent,InternalServiceTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        
        fluent.withIpFamilies(instance.getIpFamilies());
        
        this.validationEnabled = validationEnabled; 
    }

    public InternalServiceTemplateBuilder(InternalServiceTemplate instance) {
        this(instance,true);
    }

    public InternalServiceTemplateBuilder(InternalServiceTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withMetadata(instance.getMetadata());
        
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        
        this.withIpFamilies(instance.getIpFamilies());
        
        this.validationEnabled = validationEnabled; 
    }

    public InternalServiceTemplate build() {
        InternalServiceTemplate buildable = new InternalServiceTemplate();
        buildable.setMetadata(fluent.getMetadata());
        buildable.setIpFamilyPolicy(fluent.getIpFamilyPolicy());
        buildable.setIpFamilies(fluent.getIpFamilies());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InternalServiceTemplateBuilder that = (InternalServiceTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
