package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JmxTransOutputDefinitionTemplateBuilder extends JmxTransOutputDefinitionTemplateFluentImpl<JmxTransOutputDefinitionTemplateBuilder> implements VisitableBuilder<JmxTransOutputDefinitionTemplate,JmxTransOutputDefinitionTemplateBuilder> {

    JmxTransOutputDefinitionTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public JmxTransOutputDefinitionTemplateBuilder() {
        this(true);
    }

    public JmxTransOutputDefinitionTemplateBuilder(Boolean validationEnabled) {
        this(new JmxTransOutputDefinitionTemplate(), validationEnabled);
    }

    public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JmxTransOutputDefinitionTemplate(), validationEnabled);
    }

    public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplateFluent<?> fluent,JmxTransOutputDefinitionTemplate instance) {
        this(fluent, instance, true);
    }

    public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplateFluent<?> fluent,JmxTransOutputDefinitionTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withOutputType(instance.getOutputType());
        
        fluent.withHost(instance.getHost());
        
        fluent.withPort(instance.getPort());
        
        fluent.withFlushDelayInSeconds(instance.getFlushDelayInSeconds());
        
        fluent.withName(instance.getName());
        
        fluent.withTypeNames(instance.getTypeNames());
        
        this.validationEnabled = validationEnabled; 
    }

    public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplate instance) {
        this(instance,true);
    }

    public JmxTransOutputDefinitionTemplateBuilder(JmxTransOutputDefinitionTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withOutputType(instance.getOutputType());
        
        this.withHost(instance.getHost());
        
        this.withPort(instance.getPort());
        
        this.withFlushDelayInSeconds(instance.getFlushDelayInSeconds());
        
        this.withName(instance.getName());
        
        this.withTypeNames(instance.getTypeNames());
        
        this.validationEnabled = validationEnabled; 
    }

    public JmxTransOutputDefinitionTemplate build() {
        JmxTransOutputDefinitionTemplate buildable = new JmxTransOutputDefinitionTemplate();
        buildable.setOutputType(fluent.getOutputType());
        buildable.setHost(fluent.getHost());
        buildable.setPort(fluent.getPort());
        buildable.setFlushDelayInSeconds(fluent.getFlushDelayInSeconds());
        buildable.setName(fluent.getName());
        buildable.setTypeNames(fluent.getTypeNames());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JmxTransOutputDefinitionTemplateBuilder that = (JmxTransOutputDefinitionTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
