package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeTemplateBuilder extends KafkaBridgeTemplateFluentImpl<KafkaBridgeTemplateBuilder> implements VisitableBuilder<KafkaBridgeTemplate,KafkaBridgeTemplateBuilder> {

    KafkaBridgeTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBridgeTemplateBuilder() {
        this(true);
    }

    public KafkaBridgeTemplateBuilder(Boolean validationEnabled) {
        this(new KafkaBridgeTemplate(), validationEnabled);
    }

    public KafkaBridgeTemplateBuilder(KafkaBridgeTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBridgeTemplateBuilder(KafkaBridgeTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaBridgeTemplate(), validationEnabled);
    }

    public KafkaBridgeTemplateBuilder(KafkaBridgeTemplateFluent<?> fluent,KafkaBridgeTemplate instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeTemplateBuilder(KafkaBridgeTemplateFluent<?> fluent,KafkaBridgeTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withApiService(instance.getApiService());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withBridgeContainer(instance.getBridgeContainer());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeTemplateBuilder(KafkaBridgeTemplate instance) {
        this(instance,true);
    }

    public KafkaBridgeTemplateBuilder(KafkaBridgeTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withBridgeContainer(instance.getBridgeContainer());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeTemplate build() {
        KafkaBridgeTemplate buildable = new KafkaBridgeTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setApiService(fluent.getApiService());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setBridgeContainer(fluent.getBridgeContainer());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeTemplateBuilder that = (KafkaBridgeTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
