package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectTemplateBuilder extends KafkaConnectTemplateFluentImpl<KafkaConnectTemplateBuilder> implements VisitableBuilder<KafkaConnectTemplate,KafkaConnectTemplateBuilder> {

    KafkaConnectTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectTemplateBuilder() {
        this(true);
    }

    public KafkaConnectTemplateBuilder(Boolean validationEnabled) {
        this(new KafkaConnectTemplate(), validationEnabled);
    }

    public KafkaConnectTemplateBuilder(KafkaConnectTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaConnectTemplateBuilder(KafkaConnectTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaConnectTemplate(), validationEnabled);
    }

    public KafkaConnectTemplateBuilder(KafkaConnectTemplateFluent<?> fluent,KafkaConnectTemplate instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectTemplateBuilder(KafkaConnectTemplateFluent<?> fluent,KafkaConnectTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withBuildPod(instance.getBuildPod());
        
        fluent.withApiService(instance.getApiService());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withConnectContainer(instance.getConnectContainer());
        
        fluent.withInitContainer(instance.getInitContainer());
        
        fluent.withBuildContainer(instance.getBuildContainer());
        
        fluent.withBuildConfig(instance.getBuildConfig());
        
        fluent.withClusterRoleBinding(instance.getClusterRoleBinding());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectTemplateBuilder(KafkaConnectTemplate instance) {
        this(instance,true);
    }

    public KafkaConnectTemplateBuilder(KafkaConnectTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withBuildPod(instance.getBuildPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withConnectContainer(instance.getConnectContainer());
        
        this.withInitContainer(instance.getInitContainer());
        
        this.withBuildContainer(instance.getBuildContainer());
        
        this.withBuildConfig(instance.getBuildConfig());
        
        this.withClusterRoleBinding(instance.getClusterRoleBinding());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectTemplate build() {
        KafkaConnectTemplate buildable = new KafkaConnectTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setBuildPod(fluent.getBuildPod());
        buildable.setApiService(fluent.getApiService());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setConnectContainer(fluent.getConnectContainer());
        buildable.setInitContainer(fluent.getInitContainer());
        buildable.setBuildContainer(fluent.getBuildContainer());
        buildable.setBuildConfig(fluent.getBuildConfig());
        buildable.setClusterRoleBinding(fluent.getClusterRoleBinding());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectTemplateBuilder that = (KafkaConnectTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
