package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface MetadataTemplateFluent<A extends MetadataTemplateFluent<A>> extends Fluent<A> {


    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public <K extends Object,V extends Object>A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public <K extends Object,V extends Object>A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
}
