package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class MetadataTemplateFluentImpl<A extends MetadataTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MetadataTemplateFluent<A> {

    private Map<String,String> labels;
    private Map<String,String> annotations;

    public MetadataTemplateFluentImpl() {
    }

    public MetadataTemplateFluentImpl(MetadataTemplate instance) {
        this.withLabels(instance.getLabels());
        
        this.withAnnotations(instance.getAnnotations());
    }

    public A addToLabels(String key,String value) {
        if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map) {
        if(this.labels == null && map != null) { this.labels = new LinkedHashMap<String,String>(); }
        if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key) {
        if(this.labels == null) { return (A) this; }
        if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map) {
        if(this.labels == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabels() {
        return this.labels;
    }

    public <K extends Object,V extends Object>A withLabels(Map<String,String> labels) {
        if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap<String,String>(labels);} return (A) this;
    }

    public Boolean hasLabels() {
        return this.labels != null;
    }

    public A addToAnnotations(String key,String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(Map<String,String> map) {
        if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(Map<String,String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAnnotations() {
        return this.annotations;
    }

    public <K extends Object,V extends Object>A withAnnotations(Map<String,String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MetadataTemplateFluentImpl that = (MetadataTemplateFluentImpl) o;
        if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(labels,  annotations,  super.hashCode());
    }

}
