package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodDisruptionBudgetTemplateBuilder extends PodDisruptionBudgetTemplateFluentImpl<PodDisruptionBudgetTemplateBuilder> implements VisitableBuilder<PodDisruptionBudgetTemplate,PodDisruptionBudgetTemplateBuilder> {

    PodDisruptionBudgetTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public PodDisruptionBudgetTemplateBuilder() {
        this(true);
    }

    public PodDisruptionBudgetTemplateBuilder(Boolean validationEnabled) {
        this(new PodDisruptionBudgetTemplate(), validationEnabled);
    }

    public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplateFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodDisruptionBudgetTemplate(), validationEnabled);
    }

    public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplateFluent<?> fluent,PodDisruptionBudgetTemplate instance) {
        this(fluent, instance, true);
    }

    public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplateFluent<?> fluent,PodDisruptionBudgetTemplate instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withMaxUnavailable(instance.getMaxUnavailable());
        
        this.validationEnabled = validationEnabled; 
    }

    public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplate instance) {
        this(instance,true);
    }

    public PodDisruptionBudgetTemplateBuilder(PodDisruptionBudgetTemplate instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withMetadata(instance.getMetadata());
        
        this.withMaxUnavailable(instance.getMaxUnavailable());
        
        this.validationEnabled = validationEnabled; 
    }

    public PodDisruptionBudgetTemplate build() {
        PodDisruptionBudgetTemplate buildable = new PodDisruptionBudgetTemplate();
        buildable.setMetadata(fluent.getMetadata());
        buildable.setMaxUnavailable(fluent.getMaxUnavailable());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodDisruptionBudgetTemplateBuilder that = (PodDisruptionBudgetTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
