package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class StatefulSetTemplateFluentImpl<A extends StatefulSetTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StatefulSetTemplateFluent<A> {

    private MetadataTemplateBuilder metadata;
    private PodManagementPolicy podManagementPolicy;

    public StatefulSetTemplateFluentImpl() {
    }

    public StatefulSetTemplateFluentImpl(StatefulSetTemplate instance) {
        this.withMetadata(instance.getMetadata());
        
        this.withPodManagementPolicy(instance.getPodManagementPolicy());
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public MetadataTemplate getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public MetadataTemplate buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(MetadataTemplate metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new MetadataTemplateBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public StatefulSetTemplateFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public StatefulSetTemplateFluent.MetadataNested<A> withNewMetadataLike(MetadataTemplate item) {
        return new MetadataNestedImpl(item);
    }

    public StatefulSetTemplateFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public StatefulSetTemplateFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new MetadataTemplateBuilder().build());
    }

    public StatefulSetTemplateFluent.MetadataNested<A> editOrNewMetadataLike(MetadataTemplate item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public PodManagementPolicy getPodManagementPolicy() {
        return this.podManagementPolicy;
    }

    public A withPodManagementPolicy(PodManagementPolicy podManagementPolicy) {
        this.podManagementPolicy=podManagementPolicy; return (A) this;
    }

    public Boolean hasPodManagementPolicy() {
        return this.podManagementPolicy != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StatefulSetTemplateFluentImpl that = (StatefulSetTemplateFluentImpl) o;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (podManagementPolicy != null ? !podManagementPolicy.equals(that.podManagementPolicy) :that.podManagementPolicy != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(metadata,  podManagementPolicy,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends MetadataTemplateFluentImpl<StatefulSetTemplateFluent.MetadataNested<N>> implements StatefulSetTemplateFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MetadataTemplateBuilder builder;

            MetadataNestedImpl(MetadataTemplate item) {
                this.builder = new MetadataTemplateBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new MetadataTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) StatefulSetTemplateFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
