/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.CruiseControlSpec;
import io.strimzi.api.kafka.model.CruiseControlSpecFluent;
import io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl;
import java.util.Objects;

public class CruiseControlSpecBuilder
extends CruiseControlSpecFluentImpl<CruiseControlSpecBuilder>
implements VisitableBuilder<CruiseControlSpec, CruiseControlSpecBuilder> {
    CruiseControlSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CruiseControlSpecBuilder() {
        this(true);
    }

    public CruiseControlSpecBuilder(Boolean validationEnabled) {
        this(new CruiseControlSpec(), validationEnabled);
    }

    public CruiseControlSpecBuilder(CruiseControlSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CruiseControlSpecBuilder(CruiseControlSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CruiseControlSpec(), validationEnabled);
    }

    public CruiseControlSpecBuilder(CruiseControlSpecFluent<?> fluent, CruiseControlSpec instance) {
        this(fluent, instance, true);
    }

    public CruiseControlSpecBuilder(CruiseControlSpecFluent<?> fluent, CruiseControlSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImage(instance.getImage());
        fluent.withTlsSidecar(instance.getTlsSidecar());
        fluent.withResources(instance.getResources());
        fluent.withLivenessProbe(instance.getLivenessProbe());
        fluent.withReadinessProbe(instance.getReadinessProbe());
        fluent.withJvmOptions(instance.getJvmOptions());
        fluent.withLogging(instance.getLogging());
        fluent.withTemplate(instance.getTemplate());
        fluent.withBrokerCapacity(instance.getBrokerCapacity());
        fluent.withConfig(instance.getConfig());
        fluent.withMetrics(instance.getMetrics());
        fluent.withMetricsConfig(instance.getMetricsConfig());
        this.validationEnabled = validationEnabled;
    }

    public CruiseControlSpecBuilder(CruiseControlSpec instance) {
        this(instance, (Boolean)true);
    }

    public CruiseControlSpecBuilder(CruiseControlSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImage(instance.getImage());
        this.withTlsSidecar(instance.getTlsSidecar());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJvmOptions(instance.getJvmOptions());
        this.withLogging(instance.getLogging());
        this.withTemplate(instance.getTemplate());
        this.withBrokerCapacity(instance.getBrokerCapacity());
        this.withConfig(instance.getConfig());
        this.withMetrics(instance.getMetrics());
        this.withMetricsConfig(instance.getMetricsConfig());
        this.validationEnabled = validationEnabled;
    }

    public CruiseControlSpec build() {
        CruiseControlSpec buildable = new CruiseControlSpec();
        buildable.setImage(this.fluent.getImage());
        buildable.setTlsSidecar(this.fluent.getTlsSidecar());
        buildable.setResources(this.fluent.getResources());
        buildable.setLivenessProbe(this.fluent.getLivenessProbe());
        buildable.setReadinessProbe(this.fluent.getReadinessProbe());
        buildable.setJvmOptions(this.fluent.getJvmOptions());
        buildable.setLogging(this.fluent.getLogging());
        buildable.setTemplate(this.fluent.getTemplate());
        buildable.setBrokerCapacity(this.fluent.getBrokerCapacity());
        buildable.setConfig(this.fluent.getConfig());
        buildable.setMetrics(this.fluent.getMetrics());
        buildable.setMetricsConfig(this.fluent.getMetricsConfig());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CruiseControlSpecBuilder that = (CruiseControlSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

