/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.KafkaAuthorizationCustom;
import io.strimzi.api.kafka.model.KafkaAuthorizationCustomFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaAuthorizationCustomFluentImpl<A extends KafkaAuthorizationCustomFluent<A>>
extends BaseFluent<A>
implements KafkaAuthorizationCustomFluent<A> {
    private String authorizerClass;
    private List<String> superUsers;

    public KafkaAuthorizationCustomFluentImpl() {
    }

    public KafkaAuthorizationCustomFluentImpl(KafkaAuthorizationCustom instance) {
        this.withAuthorizerClass(instance.getAuthorizerClass());
        this.withSuperUsers(instance.getSuperUsers());
    }

    @Override
    public String getAuthorizerClass() {
        return this.authorizerClass;
    }

    @Override
    public A withAuthorizerClass(String authorizerClass) {
        this.authorizerClass = authorizerClass;
        return (A)this;
    }

    @Override
    public Boolean hasAuthorizerClass() {
        return this.authorizerClass != null;
    }

    @Override
    public A withNewAuthorizerClass(StringBuilder arg1) {
        return this.withAuthorizerClass(new String(arg1));
    }

    @Override
    public A withNewAuthorizerClass(int[] arg1, int arg2, int arg3) {
        return this.withAuthorizerClass(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewAuthorizerClass(char[] arg1) {
        return this.withAuthorizerClass(new String(arg1));
    }

    @Override
    public A withNewAuthorizerClass(StringBuffer arg1) {
        return this.withAuthorizerClass(new String(arg1));
    }

    @Override
    public A withNewAuthorizerClass(byte[] arg1, int arg2) {
        return this.withAuthorizerClass(new String(arg1, arg2));
    }

    @Override
    public A withNewAuthorizerClass(byte[] arg1) {
        return this.withAuthorizerClass(new String(arg1));
    }

    @Override
    public A withNewAuthorizerClass(char[] arg1, int arg2, int arg3) {
        return this.withAuthorizerClass(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewAuthorizerClass(byte[] arg1, int arg2, int arg3) {
        return this.withAuthorizerClass(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewAuthorizerClass(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withAuthorizerClass(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewAuthorizerClass(String arg1) {
        return this.withAuthorizerClass(new String(arg1));
    }

    @Override
    public A addToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSuperUsers(String ... items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSuperUsers(Collection<String> items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSuperUsers(String ... items) {
        for (String item : items) {
            if (this.superUsers == null) continue;
            this.superUsers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSuperUsers(Collection<String> items) {
        for (String item : items) {
            if (this.superUsers == null) continue;
            this.superUsers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    @Override
    public String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    @Override
    public String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    @Override
    public String getLastSuperUser() {
        return this.superUsers.get(this.superUsers.size() - 1);
    }

    @Override
    public String getMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSuperUsers(List<String> superUsers) {
        if (this.superUsers != null) {
            this._visitables.get((Object)"superUsers").removeAll(this.superUsers);
        }
        if (superUsers != null) {
            this.superUsers = new ArrayList<String>();
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        } else {
            this.superUsers = null;
        }
        return (A)this;
    }

    @Override
    public A withSuperUsers(String ... superUsers) {
        if (this.superUsers != null) {
            this.superUsers.clear();
        }
        if (superUsers != null) {
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSuperUsers() {
        return this.superUsers != null && !this.superUsers.isEmpty();
    }

    @Override
    public A addNewSuperUser(StringBuilder arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public A addNewSuperUser(int[] arg1, int arg2, int arg3) {
        return this.addToSuperUsers(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewSuperUser(char[] arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public A addNewSuperUser(StringBuffer arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public A addNewSuperUser(byte[] arg1, int arg2) {
        return this.addToSuperUsers(new String(arg1, arg2));
    }

    @Override
    public A addNewSuperUser(byte[] arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public A addNewSuperUser(char[] arg1, int arg2, int arg3) {
        return this.addToSuperUsers(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewSuperUser(byte[] arg1, int arg2, int arg3) {
        return this.addToSuperUsers(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewSuperUser(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToSuperUsers(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewSuperUser(String arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaAuthorizationCustomFluentImpl that = (KafkaAuthorizationCustomFluentImpl)o;
        if (this.authorizerClass != null ? !this.authorizerClass.equals(that.authorizerClass) : that.authorizerClass != null) {
            return false;
        }
        return !(this.superUsers != null ? !this.superUsers.equals(that.superUsers) : that.superUsers != null);
    }

    public int hashCode() {
        return Objects.hash(this.authorizerClass, this.superUsers, super.hashCode());
    }
}

