/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.KafkaAuthorizationOpa;
import io.strimzi.api.kafka.model.KafkaAuthorizationOpaFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaAuthorizationOpaFluentImpl<A extends KafkaAuthorizationOpaFluent<A>>
extends BaseFluent<A>
implements KafkaAuthorizationOpaFluent<A> {
    private List<String> superUsers;
    private String url;
    private boolean allowOnError;
    private int initialCacheCapacity;
    private int maximumCacheSize;
    private long expireAfterMs;

    public KafkaAuthorizationOpaFluentImpl() {
    }

    public KafkaAuthorizationOpaFluentImpl(KafkaAuthorizationOpa instance) {
        this.withSuperUsers(instance.getSuperUsers());
        this.withUrl(instance.getUrl());
        this.withAllowOnError(instance.isAllowOnError());
        this.withInitialCacheCapacity(instance.getInitialCacheCapacity());
        this.withMaximumCacheSize(instance.getMaximumCacheSize());
        this.withExpireAfterMs(instance.getExpireAfterMs());
    }

    @Override
    public A addToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSuperUsers(String ... items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSuperUsers(Collection<String> items) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSuperUsers(String ... items) {
        for (String item : items) {
            if (this.superUsers == null) continue;
            this.superUsers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSuperUsers(Collection<String> items) {
        for (String item : items) {
            if (this.superUsers == null) continue;
            this.superUsers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    @Override
    public String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    @Override
    public String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    @Override
    public String getLastSuperUser() {
        return this.superUsers.get(this.superUsers.size() - 1);
    }

    @Override
    public String getMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSuperUsers(List<String> superUsers) {
        if (this.superUsers != null) {
            this._visitables.get((Object)"superUsers").removeAll(this.superUsers);
        }
        if (superUsers != null) {
            this.superUsers = new ArrayList<String>();
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        } else {
            this.superUsers = null;
        }
        return (A)this;
    }

    @Override
    public A withSuperUsers(String ... superUsers) {
        if (this.superUsers != null) {
            this.superUsers.clear();
        }
        if (superUsers != null) {
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSuperUsers() {
        return this.superUsers != null && !this.superUsers.isEmpty();
    }

    @Override
    public A addNewSuperUser(StringBuilder arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public A addNewSuperUser(int[] arg1, int arg2, int arg3) {
        return this.addToSuperUsers(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewSuperUser(char[] arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public A addNewSuperUser(StringBuffer arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public A addNewSuperUser(byte[] arg1, int arg2) {
        return this.addToSuperUsers(new String(arg1, arg2));
    }

    @Override
    public A addNewSuperUser(byte[] arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public A addNewSuperUser(char[] arg1, int arg2, int arg3) {
        return this.addToSuperUsers(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewSuperUser(byte[] arg1, int arg2, int arg3) {
        return this.addToSuperUsers(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewSuperUser(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToSuperUsers(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewSuperUser(String arg1) {
        return this.addToSuperUsers(new String(arg1));
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public A withNewUrl(StringBuilder arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A withNewUrl(int[] arg1, int arg2, int arg3) {
        return this.withUrl(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewUrl(char[] arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A withNewUrl(StringBuffer arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A withNewUrl(byte[] arg1, int arg2) {
        return this.withUrl(new String(arg1, arg2));
    }

    @Override
    public A withNewUrl(byte[] arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public A withNewUrl(char[] arg1, int arg2, int arg3) {
        return this.withUrl(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewUrl(byte[] arg1, int arg2, int arg3) {
        return this.withUrl(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewUrl(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withUrl(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewUrl(String arg1) {
        return this.withUrl(new String(arg1));
    }

    @Override
    public boolean isAllowOnError() {
        return this.allowOnError;
    }

    @Override
    public A withAllowOnError(boolean allowOnError) {
        this.allowOnError = allowOnError;
        return (A)this;
    }

    @Override
    public Boolean hasAllowOnError() {
        return true;
    }

    @Override
    public int getInitialCacheCapacity() {
        return this.initialCacheCapacity;
    }

    @Override
    public A withInitialCacheCapacity(int initialCacheCapacity) {
        this.initialCacheCapacity = initialCacheCapacity;
        return (A)this;
    }

    @Override
    public Boolean hasInitialCacheCapacity() {
        return true;
    }

    @Override
    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    @Override
    public A withMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
        return (A)this;
    }

    @Override
    public Boolean hasMaximumCacheSize() {
        return true;
    }

    @Override
    public long getExpireAfterMs() {
        return this.expireAfterMs;
    }

    @Override
    public A withExpireAfterMs(long expireAfterMs) {
        this.expireAfterMs = expireAfterMs;
        return (A)this;
    }

    @Override
    public Boolean hasExpireAfterMs() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaAuthorizationOpaFluentImpl that = (KafkaAuthorizationOpaFluentImpl)o;
        if (this.superUsers != null ? !this.superUsers.equals(that.superUsers) : that.superUsers != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.allowOnError != that.allowOnError) {
            return false;
        }
        if (this.initialCacheCapacity != that.initialCacheCapacity) {
            return false;
        }
        if (this.maximumCacheSize != that.maximumCacheSize) {
            return false;
        }
        return this.expireAfterMs == that.expireAfterMs;
    }

    public int hashCode() {
        return Objects.hash(this.superUsers, this.url, this.allowOnError, this.initialCacheCapacity, this.maximumCacheSize, this.expireAfterMs, super.hashCode());
    }
}

