/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.KafkaAuthorization;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.Example;
import java.util.List;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "superUsers"})
public class KafkaAuthorizationSimple
extends KafkaAuthorization {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_SIMPLE = "simple";
    public static final String AUTHORIZER_CLASS_NAME = "kafka.security.authorizer.AclAuthorizer";
    private List<String> superUsers;

    @Override
    @Description(value="Must be `simple`")
    public String getType() {
        return TYPE_SIMPLE;
    }

    @Description(value="List of super users. Should contain list of user principals which should get unlimited access rights.")
    @Example(value="- CN=my-user\n- CN=my-other-user")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    public void setSuperUsers(List<String> superUsers) {
        this.superUsers = superUsers;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaAuthorizationSimple)) {
            return false;
        }
        KafkaAuthorizationSimple other = (KafkaAuthorizationSimple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$superUsers = this.getSuperUsers();
        List<String> other$superUsers = other.getSuperUsers();
        return !(this$superUsers == null ? other$superUsers != null : !((Object)this$superUsers).equals(other$superUsers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaAuthorizationSimple;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $superUsers = this.getSuperUsers();
        result = result * 59 + ($superUsers == null ? 43 : ((Object)$superUsers).hashCode());
        return result;
    }
}

