/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaBridge;
import io.strimzi.api.kafka.model.KafkaBridgeFluent;
import io.strimzi.api.kafka.model.KafkaBridgeFluentImpl;
import java.util.Objects;

public class KafkaBridgeBuilder
extends KafkaBridgeFluentImpl<KafkaBridgeBuilder>
implements VisitableBuilder<KafkaBridge, KafkaBridgeBuilder> {
    KafkaBridgeFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBridgeBuilder() {
        this(true);
    }

    public KafkaBridgeBuilder(Boolean validationEnabled) {
        this(new KafkaBridge(), validationEnabled);
    }

    public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaBridge(), validationEnabled);
    }

    public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent, KafkaBridge instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent, KafkaBridge instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public KafkaBridgeBuilder(KafkaBridge instance) {
        this(instance, (Boolean)true);
    }

    public KafkaBridgeBuilder(KafkaBridge instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public KafkaBridge build() {
        KafkaBridge buildable = new KafkaBridge();
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setMetadata(this.fluent.getMetadata());
        buildable.setSpec(this.fluent.getSpec());
        buildable.setStatus(this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaBridgeBuilder that = (KafkaBridgeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

