/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaFluent;
import io.strimzi.api.kafka.model.KafkaFluentImpl;
import java.util.Objects;

public class KafkaBuilder
extends KafkaFluentImpl<KafkaBuilder>
implements VisitableBuilder<Kafka, KafkaBuilder> {
    KafkaFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBuilder() {
        this(true);
    }

    public KafkaBuilder(Boolean validationEnabled) {
        this(new Kafka(), validationEnabled);
    }

    public KafkaBuilder(KafkaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaBuilder(KafkaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Kafka(), validationEnabled);
    }

    public KafkaBuilder(KafkaFluent<?> fluent, Kafka instance) {
        this(fluent, instance, true);
    }

    public KafkaBuilder(KafkaFluent<?> fluent, Kafka instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public KafkaBuilder(Kafka instance) {
        this(instance, (Boolean)true);
    }

    public KafkaBuilder(Kafka instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public Kafka build() {
        Kafka buildable = new Kafka();
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setMetadata(this.fluent.getMetadata());
        buildable.setSpec(this.fluent.getSpec());
        buildable.setStatus(this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaBuilder that = (KafkaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

