/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.strimzi.api.kafka.model.KafkaConnectorSpec;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatus;
import io.strimzi.crdgenerator.annotations.Crd;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Crd(spec=@Crd.Spec(names=@Crd.Spec.Names(kind="KafkaConnector", plural="kafkaconnectors", shortNames={"kctr"}, categories={"strimzi"}), group="kafka.strimzi.io", scope="Namespaced", versions={@Crd.Spec.Version(name="v1beta2", served=true, storage=false), @Crd.Spec.Version(name="v1alpha1", served=true, storage=true)}, subresources=@Crd.Spec.Subresources(status={@Crd.Spec.Subresources.Status}, scale={@Crd.Spec.Subresources.Scale(specReplicasPath=".spec.tasksMax", statusReplicasPath=".status.tasksMax")}), additionalPrinterColumns={@Crd.Spec.AdditionalPrinterColumn(name="Cluster", description="The name of the Kafka Connect cluster this connector belongs to", jsonPath=".metadata.labels.strimzi\\.io/cluster", type="string"), @Crd.Spec.AdditionalPrinterColumn(name="Connector class", description="The class used by this connector", jsonPath=".spec.class", type="string"), @Crd.Spec.AdditionalPrinterColumn(name="Max Tasks", description="Maximum number of tasks", jsonPath=".spec.tasksMax", type="integer"), @Crd.Spec.AdditionalPrinterColumn(name="Ready", description="The state of the custom resource", jsonPath=".status.conditions[?(@.type==\"Ready\")].status", type="string")}))
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
@Version(value="v1beta2")
@Group(value="kafka.strimzi.io")
public class KafkaConnector
extends CustomResource<KafkaConnectorSpec, KafkaConnectorStatus>
implements Namespaced,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    public static final String V1BETA2 = "v1beta2";
    public static final String V1ALPHA1 = "v1alpha1";
    public static final String CONSUMED_VERSION = "v1beta2";
    public static final List<String> VERSIONS = Collections.unmodifiableList(Arrays.asList("v1beta2", "v1alpha1"));
    public static final String SCOPE = "Namespaced";
    public static final String RESOURCE_PLURAL = "kafkaconnectors";
    public static final String RESOURCE_SINGULAR = "kafkaconnector";
    public static final String RESOURCE_GROUP = "kafka.strimzi.io";
    public static final String RESOURCE_KIND = "KafkaConnector";
    public static final String RESOURCE_LIST_KIND = "KafkaConnectorList";
    public static final String CRD_NAME = "kafkaconnectors.kafka.strimzi.io";
    public static final String SHORT_NAME = "kctr";
    public static final String SPEC_REPLICAS_PATH = ".spec.tasksMax";
    public static final String STATUS_REPLICAS_PATH = ".status.tasksMax";
    private KafkaConnectorSpec spec;
    private KafkaConnectorStatus status;
    private Map<String, Object> additionalProperties;
    private ObjectMeta metadata;
    private String apiVersion;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return RESOURCE_KIND;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @Description(value="The specification of the Kafka Connector.")
    public KafkaConnectorSpec getSpec() {
        return this.spec;
    }

    public void setSpec(KafkaConnectorSpec spec) {
        this.spec = spec;
    }

    @Description(value="The status of the Kafka Connector.")
    public KafkaConnectorStatus getStatus() {
        return this.status;
    }

    public void setStatus(KafkaConnectorStatus status) {
        this.status = status;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Collections.emptyMap();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(1);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConnector)) {
            return false;
        }
        KafkaConnector other = (KafkaConnector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KafkaConnectorSpec this$spec = this.getSpec();
        KafkaConnectorSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        KafkaConnectorStatus this$status = this.getStatus();
        KafkaConnectorStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        if (this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        return !(this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConnector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KafkaConnectorSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        KafkaConnectorStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaConnector(spec=" + this.getSpec() + ", status=" + this.getStatus() + ", additionalProperties=" + this.getAdditionalProperties() + ", metadata=" + this.getMetadata() + ", apiVersion=" + this.getApiVersion() + ")";
    }
}

