/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"image", "groupRegex", "topicRegex", "resources", "logging", "enableSaramaLogging", "template"})
public class KafkaExporterSpec
implements UnknownPropertyPreserving,
Serializable {
    private static final long serialVersionUID = 1L;
    private String image;
    private String groupRegex = ".*";
    private String topicRegex = ".*";
    private ResourceRequirements resources;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private String logging = "info";
    private boolean enableSaramaLogging;
    private KafkaExporterTemplate template;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="The docker image for the pods.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Description(value="Regular expression to specify which consumer groups to collect. Default value is `.*`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getGroupRegex() {
        return this.groupRegex;
    }

    public void setGroupRegex(String groupRegex) {
        this.groupRegex = groupRegex;
    }

    @Description(value="Regular expression to specify which topics to collect. Default value is `.*`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getTopicRegex() {
        return this.topicRegex;
    }

    public void setTopicRegex(String topicRegex) {
        this.topicRegex = topicRegex;
    }

    @Description(value="Enable Sarama logging, a Go client library used by the Kafka Exporter.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean getEnableSaramaLogging() {
        return this.enableSaramaLogging;
    }

    public void setEnableSaramaLogging(boolean enableSaramaLogging) {
        this.enableSaramaLogging = enableSaramaLogging;
    }

    @Description(value="Only log messages with the given severity or above. Valid levels: [`debug`, `info`, `warn`, `error`, `fatal`]. Default log level is `info`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String logging) {
        this.logging = logging;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @KubeLink(group="core", version="v1", kind="resourcerequirements")
    @Description(value="CPU and memory resources to reserve.")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod liveness check.")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod readiness check.")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @Description(value="Customization of deployment templates and pods.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public KafkaExporterTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(KafkaExporterTemplate template) {
        this.template = template;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaExporterSpec)) {
            return false;
        }
        KafkaExporterSpec other = (KafkaExporterSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$groupRegex = this.getGroupRegex();
        String other$groupRegex = other.getGroupRegex();
        if (this$groupRegex == null ? other$groupRegex != null : !this$groupRegex.equals(other$groupRegex)) {
            return false;
        }
        String this$topicRegex = this.getTopicRegex();
        String other$topicRegex = other.getTopicRegex();
        if (this$topicRegex == null ? other$topicRegex != null : !this$topicRegex.equals(other$topicRegex)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        Probe this$livenessProbe = this.getLivenessProbe();
        Probe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.getReadinessProbe();
        Probe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        String this$logging = this.getLogging();
        String other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !this$logging.equals(other$logging)) {
            return false;
        }
        if (this.getEnableSaramaLogging() != other.getEnableSaramaLogging()) {
            return false;
        }
        KafkaExporterTemplate this$template = this.getTemplate();
        KafkaExporterTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaExporterSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $groupRegex = this.getGroupRegex();
        result = result * 59 + ($groupRegex == null ? 43 : $groupRegex.hashCode());
        String $topicRegex = this.getTopicRegex();
        result = result * 59 + ($topicRegex == null ? 43 : $topicRegex.hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        Probe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        String $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : $logging.hashCode());
        result = result * 59 + (this.getEnableSaramaLogging() ? 79 : 97);
        KafkaExporterTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

