/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaRebalanceSpec;
import io.strimzi.api.kafka.model.KafkaRebalanceSpecFluent;
import io.strimzi.api.kafka.model.KafkaRebalanceSpecFluentImpl;
import java.util.Objects;

public class KafkaRebalanceSpecBuilder
extends KafkaRebalanceSpecFluentImpl<KafkaRebalanceSpecBuilder>
implements VisitableBuilder<KafkaRebalanceSpec, KafkaRebalanceSpecBuilder> {
    KafkaRebalanceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaRebalanceSpecBuilder() {
        this(true);
    }

    public KafkaRebalanceSpecBuilder(Boolean validationEnabled) {
        this(new KafkaRebalanceSpec(), validationEnabled);
    }

    public KafkaRebalanceSpecBuilder(KafkaRebalanceSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaRebalanceSpecBuilder(KafkaRebalanceSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaRebalanceSpec(), validationEnabled);
    }

    public KafkaRebalanceSpecBuilder(KafkaRebalanceSpecFluent<?> fluent, KafkaRebalanceSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaRebalanceSpecBuilder(KafkaRebalanceSpecFluent<?> fluent, KafkaRebalanceSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withGoals(instance.getGoals());
        fluent.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
        fluent.withExcludedTopics(instance.getExcludedTopics());
        fluent.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
        fluent.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
        fluent.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
        fluent.withReplicationThrottle(instance.getReplicationThrottle());
        fluent.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
        this.validationEnabled = validationEnabled;
    }

    public KafkaRebalanceSpecBuilder(KafkaRebalanceSpec instance) {
        this(instance, (Boolean)true);
    }

    public KafkaRebalanceSpecBuilder(KafkaRebalanceSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withGoals(instance.getGoals());
        this.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
        this.withExcludedTopics(instance.getExcludedTopics());
        this.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
        this.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
        this.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
        this.withReplicationThrottle(instance.getReplicationThrottle());
        this.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
        this.validationEnabled = validationEnabled;
    }

    public KafkaRebalanceSpec build() {
        KafkaRebalanceSpec buildable = new KafkaRebalanceSpec();
        buildable.setGoals(this.fluent.getGoals());
        buildable.setSkipHardGoalCheck(this.fluent.isSkipHardGoalCheck());
        buildable.setExcludedTopics(this.fluent.getExcludedTopics());
        buildable.setConcurrentPartitionMovementsPerBroker(this.fluent.getConcurrentPartitionMovementsPerBroker());
        buildable.setConcurrentIntraBrokerPartitionMovements(this.fluent.getConcurrentIntraBrokerPartitionMovements());
        buildable.setConcurrentLeaderMovements(this.fluent.getConcurrentLeaderMovements());
        buildable.setReplicationThrottle(this.fluent.getReplicationThrottle());
        buildable.setReplicaMovementStrategies(this.fluent.getReplicaMovementStrategies());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaRebalanceSpecBuilder that = (KafkaRebalanceSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

