/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaUser;
import io.strimzi.api.kafka.model.KafkaUserFluent;
import io.strimzi.api.kafka.model.KafkaUserFluentImpl;
import java.util.Objects;

public class KafkaUserBuilder
extends KafkaUserFluentImpl<KafkaUserBuilder>
implements VisitableBuilder<KafkaUser, KafkaUserBuilder> {
    KafkaUserFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserBuilder() {
        this(true);
    }

    public KafkaUserBuilder(Boolean validationEnabled) {
        this(new KafkaUser(), validationEnabled);
    }

    public KafkaUserBuilder(KafkaUserFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaUserBuilder(KafkaUserFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaUser(), validationEnabled);
    }

    public KafkaUserBuilder(KafkaUserFluent<?> fluent, KafkaUser instance) {
        this(fluent, instance, true);
    }

    public KafkaUserBuilder(KafkaUserFluent<?> fluent, KafkaUser instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public KafkaUserBuilder(KafkaUser instance) {
        this(instance, (Boolean)true);
    }

    public KafkaUserBuilder(KafkaUser instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public KafkaUser build() {
        KafkaUser buildable = new KafkaUser();
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setMetadata(this.fluent.getMetadata());
        buildable.setSpec(this.fluent.getSpec());
        buildable.setStatus(this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaUserBuilder that = (KafkaUserBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

