/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.balancing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.balancing.BrokerCapacity;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityFluent;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityFluentImpl;
import java.util.Objects;

public class BrokerCapacityBuilder
extends BrokerCapacityFluentImpl<BrokerCapacityBuilder>
implements VisitableBuilder<BrokerCapacity, BrokerCapacityBuilder> {
    BrokerCapacityFluent<?> fluent;
    Boolean validationEnabled;

    public BrokerCapacityBuilder() {
        this(true);
    }

    public BrokerCapacityBuilder(Boolean validationEnabled) {
        this(new BrokerCapacity(), validationEnabled);
    }

    public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BrokerCapacity(), validationEnabled);
    }

    public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent, BrokerCapacity instance) {
        this(fluent, instance, true);
    }

    public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent, BrokerCapacity instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDisk(instance.getDisk());
        fluent.withCpuUtilization(instance.getCpuUtilization());
        fluent.withInboundNetwork(instance.getInboundNetwork());
        fluent.withOutboundNetwork(instance.getOutboundNetwork());
        this.validationEnabled = validationEnabled;
    }

    public BrokerCapacityBuilder(BrokerCapacity instance) {
        this(instance, (Boolean)true);
    }

    public BrokerCapacityBuilder(BrokerCapacity instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDisk(instance.getDisk());
        this.withCpuUtilization(instance.getCpuUtilization());
        this.withInboundNetwork(instance.getInboundNetwork());
        this.withOutboundNetwork(instance.getOutboundNetwork());
        this.validationEnabled = validationEnabled;
    }

    public BrokerCapacity build() {
        BrokerCapacity buildable = new BrokerCapacity();
        buildable.setDisk(this.fluent.getDisk());
        buildable.setCpuUtilization(this.fluent.getCpuUtilization());
        buildable.setInboundNetwork(this.fluent.getInboundNetwork());
        buildable.setOutboundNetwork(this.fluent.getOutboundNetwork());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BrokerCapacityBuilder that = (BrokerCapacityBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

