/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.status;

import io.strimzi.api.kafka.model.status.KafkaConnectorStatus;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluent;
import io.strimzi.api.kafka.model.status.StatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaConnectorStatusFluentImpl<A extends KafkaConnectorStatusFluent<A>>
extends StatusFluentImpl<A>
implements KafkaConnectorStatusFluent<A> {
    private Map<String, Object> connectorStatus;
    private int tasksMax;
    private List<String> topics;

    public KafkaConnectorStatusFluentImpl() {
    }

    public KafkaConnectorStatusFluentImpl(KafkaConnectorStatus instance) {
        this.withConnectorStatus(instance.getConnectorStatus());
        this.withTasksMax(instance.getTasksMax());
        this.withTopics(instance.getTopics());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    public A addToConnectorStatus(String key, Object value) {
        if (this.connectorStatus == null && key != null && value != null) {
            this.connectorStatus = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.connectorStatus.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConnectorStatus(Map<String, Object> map) {
        if (this.connectorStatus == null && map != null) {
            this.connectorStatus = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.connectorStatus.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConnectorStatus(String key) {
        if (this.connectorStatus == null) {
            return (A)this;
        }
        if (key != null && this.connectorStatus != null) {
            this.connectorStatus.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConnectorStatus(Map<String, Object> map) {
        if (this.connectorStatus == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.connectorStatus == null) continue;
                this.connectorStatus.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConnectorStatus() {
        return this.connectorStatus;
    }

    @Override
    public <K, V> A withConnectorStatus(Map<String, Object> connectorStatus) {
        this.connectorStatus = connectorStatus == null ? null : new LinkedHashMap<String, Object>(connectorStatus);
        return (A)this;
    }

    @Override
    public Boolean hasConnectorStatus() {
        return this.connectorStatus != null;
    }

    @Override
    public int getTasksMax() {
        return this.tasksMax;
    }

    @Override
    public A withTasksMax(int tasksMax) {
        this.tasksMax = tasksMax;
        return (A)this;
    }

    @Override
    public Boolean hasTasksMax() {
        return true;
    }

    @Override
    public A addToTopics(int index, String item) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        this.topics.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopics(int index, String item) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        this.topics.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopics(String ... items) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        for (String item : items) {
            this.topics.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopics(Collection<String> items) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        for (String item : items) {
            this.topics.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopics(String ... items) {
        for (String item : items) {
            if (this.topics == null) continue;
            this.topics.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopics(Collection<String> items) {
        for (String item : items) {
            if (this.topics == null) continue;
            this.topics.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTopics() {
        return this.topics;
    }

    @Override
    public String getTopic(int index) {
        return this.topics.get(index);
    }

    @Override
    public String getFirstTopic() {
        return this.topics.get(0);
    }

    @Override
    public String getLastTopic() {
        return this.topics.get(this.topics.size() - 1);
    }

    @Override
    public String getMatchingTopic(Predicate<String> predicate) {
        for (String item : this.topics) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopic(Predicate<String> predicate) {
        for (String item : this.topics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopics(List<String> topics) {
        if (this.topics != null) {
            this._visitables.get((Object)"topics").removeAll(this.topics);
        }
        if (topics != null) {
            this.topics = new ArrayList<String>();
            for (String item : topics) {
                this.addToTopics(item);
            }
        } else {
            this.topics = null;
        }
        return (A)this;
    }

    @Override
    public A withTopics(String ... topics) {
        if (this.topics != null) {
            this.topics.clear();
        }
        if (topics != null) {
            for (String item : topics) {
                this.addToTopics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopics() {
        return this.topics != null && !this.topics.isEmpty();
    }

    @Override
    public A addNewTopic(StringBuilder arg1) {
        return this.addToTopics(new String(arg1));
    }

    @Override
    public A addNewTopic(int[] arg1, int arg2, int arg3) {
        return this.addToTopics(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewTopic(char[] arg1) {
        return this.addToTopics(new String(arg1));
    }

    @Override
    public A addNewTopic(StringBuffer arg1) {
        return this.addToTopics(new String(arg1));
    }

    @Override
    public A addNewTopic(byte[] arg1, int arg2) {
        return this.addToTopics(new String(arg1, arg2));
    }

    @Override
    public A addNewTopic(byte[] arg1) {
        return this.addToTopics(new String(arg1));
    }

    @Override
    public A addNewTopic(char[] arg1, int arg2, int arg3) {
        return this.addToTopics(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewTopic(byte[] arg1, int arg2, int arg3) {
        return this.addToTopics(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewTopic(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToTopics(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewTopic(String arg1) {
        return this.addToTopics(new String(arg1));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectorStatusFluentImpl that = (KafkaConnectorStatusFluentImpl)o;
        if (this.connectorStatus != null ? !this.connectorStatus.equals(that.connectorStatus) : that.connectorStatus != null) {
            return false;
        }
        if (this.tasksMax != that.tasksMax) {
            return false;
        }
        return !(this.topics != null ? !this.topics.equals(that.topics) : that.topics != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.connectorStatus, this.tasksMax, this.topics, super.hashCode());
    }
}

