/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.strimzi.api.kafka.model.ContainerEnvVar;
import io.strimzi.api.kafka.model.ContainerEnvVarBuilder;
import io.strimzi.api.kafka.model.ContainerEnvVarFluentImpl;
import io.strimzi.api.kafka.model.template.ContainerTemplate;
import io.strimzi.api.kafka.model.template.ContainerTemplateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ContainerTemplateFluentImpl<A extends ContainerTemplateFluent<A>>
extends BaseFluent<A>
implements ContainerTemplateFluent<A> {
    private List<ContainerEnvVarBuilder> env;
    private SecurityContext securityContext;

    public ContainerTemplateFluentImpl() {
    }

    public ContainerTemplateFluentImpl(ContainerTemplate instance) {
        this.withEnv(instance.getEnv());
        this.withSecurityContext(instance.getSecurityContext());
    }

    @Override
    public A addToEnv(int index, ContainerEnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<ContainerEnvVarBuilder>();
        }
        ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
        this._visitables.get((Object)"env").add(index >= 0 ? index : this._visitables.get((Object)"env").size(), builder);
        this.env.add(index >= 0 ? index : this.env.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, ContainerEnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<ContainerEnvVarBuilder>();
        }
        ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"env").size()) {
            this._visitables.get((Object)"env").add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
        }
        if (index < 0 || index >= this.env.size()) {
            this.env.add(builder);
        } else {
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(ContainerEnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<ContainerEnvVarBuilder>();
        }
        for (ContainerEnvVar item : items) {
            ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<ContainerEnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<ContainerEnvVarBuilder>();
        }
        for (ContainerEnvVar item : items) {
            ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(ContainerEnvVar ... items) {
        for (ContainerEnvVar item : items) {
            ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<ContainerEnvVar> items) {
        for (ContainerEnvVar item : items) {
            ContainerEnvVarBuilder builder = new ContainerEnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEnv(Predicate<ContainerEnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)this;
        }
        Iterator<ContainerEnvVarBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            ContainerEnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerEnvVar> getEnv() {
        return ContainerTemplateFluentImpl.build(this.env);
    }

    @Override
    public List<ContainerEnvVar> buildEnv() {
        return ContainerTemplateFluentImpl.build(this.env);
    }

    @Override
    public ContainerEnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    @Override
    public ContainerEnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public ContainerEnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public ContainerEnvVar buildMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate) {
        for (ContainerEnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate) {
        for (ContainerEnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<ContainerEnvVar> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").removeAll(this.env);
        }
        if (env != null) {
            this.env = new ArrayList<ContainerEnvVarBuilder>();
            for (ContainerEnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    @Override
    public A withEnv(ContainerEnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (ContainerEnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public ContainerTemplateFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public ContainerTemplateFluent.EnvNested<A> addNewEnvLike(ContainerEnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public ContainerTemplateFluent.EnvNested<A> setNewEnvLike(int index, ContainerEnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public ContainerTemplateFluent.EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ContainerTemplateFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public ContainerTemplateFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ContainerTemplateFluent.EnvNested<A> editMatchingEnv(Predicate<ContainerEnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public A withSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerTemplateFluentImpl that = (ContainerTemplateFluentImpl)o;
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        return !(this.securityContext != null ? !this.securityContext.equals((Object)that.securityContext) : that.securityContext != null);
    }

    public int hashCode() {
        return Objects.hash(this.env, this.securityContext, super.hashCode());
    }

    public class EnvNestedImpl<N>
    extends ContainerEnvVarFluentImpl<ContainerTemplateFluent.EnvNested<N>>
    implements ContainerTemplateFluent.EnvNested<N>,
    Nested<N> {
        private final ContainerEnvVarBuilder builder;
        private final int index;

        EnvNestedImpl(int index, ContainerEnvVar item) {
            this.index = index;
            this.builder = new ContainerEnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new ContainerEnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerTemplateFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

