/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.template.PodTemplate;
import io.strimzi.api.kafka.model.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.template.PodTemplateFluentImpl;
import java.util.Objects;

public class PodTemplateBuilder
extends PodTemplateFluentImpl<PodTemplateBuilder>
implements VisitableBuilder<PodTemplate, PodTemplateBuilder> {
    PodTemplateFluent<?> fluent;
    Boolean validationEnabled;

    public PodTemplateBuilder() {
        this(true);
    }

    public PodTemplateBuilder(Boolean validationEnabled) {
        this(new PodTemplate(), validationEnabled);
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodTemplate(), validationEnabled);
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent, PodTemplate instance) {
        this(fluent, instance, true);
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent, PodTemplate instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMetadata(instance.getMetadata());
        fluent.withImagePullSecrets(instance.getImagePullSecrets());
        fluent.withSecurityContext(instance.getSecurityContext());
        fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        fluent.withAffinity(instance.getAffinity());
        fluent.withTolerations(instance.getTolerations());
        fluent.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        fluent.withPriorityClassName(instance.getPriorityClassName());
        fluent.withSchedulerName(instance.getSchedulerName());
        fluent.withHostAliases(instance.getHostAliases());
        fluent.withEnableServiceLinks(instance.getEnableServiceLinks());
        this.validationEnabled = validationEnabled;
    }

    public PodTemplateBuilder(PodTemplate instance) {
        this(instance, (Boolean)true);
    }

    public PodTemplateBuilder(PodTemplate instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMetadata(instance.getMetadata());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withSecurityContext(instance.getSecurityContext());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withAffinity(instance.getAffinity());
        this.withTolerations(instance.getTolerations());
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        this.withPriorityClassName(instance.getPriorityClassName());
        this.withSchedulerName(instance.getSchedulerName());
        this.withHostAliases(instance.getHostAliases());
        this.withEnableServiceLinks(instance.getEnableServiceLinks());
        this.validationEnabled = validationEnabled;
    }

    public PodTemplate build() {
        PodTemplate buildable = new PodTemplate();
        buildable.setMetadata(this.fluent.getMetadata());
        buildable.setImagePullSecrets(this.fluent.getImagePullSecrets());
        buildable.setSecurityContext(this.fluent.getSecurityContext());
        buildable.setTerminationGracePeriodSeconds(this.fluent.getTerminationGracePeriodSeconds());
        buildable.setAffinity(this.fluent.getAffinity());
        buildable.setTolerations(this.fluent.getTolerations());
        buildable.setTopologySpreadConstraints(this.fluent.getTopologySpreadConstraints());
        buildable.setPriorityClassName(this.fluent.getPriorityClassName());
        buildable.setSchedulerName(this.fluent.getSchedulerName());
        buildable.setHostAliases(this.fluent.getHostAliases());
        buildable.setEnableServiceLinks(this.fluent.getEnableServiceLinks());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodTemplateBuilder that = (PodTemplateBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

