package io.strimzi.api.kafka.model;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

  
  /**
   * Abstracts connector config. Connectors for MM2 do not have the {@code className} property
   * while {@code KafkaConnectors} must have it.
   */
  public class AbstractConnectorSpecFluentImpl<A extends io.strimzi.api.kafka.model.AbstractConnectorSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluentImpl<A> implements io.strimzi.api.kafka.model.AbstractConnectorSpecFluent<A> {

    private java.lang.Integer tasksMax;
    private java.lang.Boolean pause;
    private java.util.Map<java.lang.String,java.lang.Object> config;

    public AbstractConnectorSpecFluentImpl() {
    }

    public AbstractConnectorSpecFluentImpl(io.strimzi.api.kafka.model.AbstractConnectorSpec instance) {
        this.withTasksMax(instance.getTasksMax());
        
        this.withPause(instance.getPause());
        
        this.withConfig(instance.getConfig());
    }

    public java.lang.Integer getTasksMax() {
        return this.tasksMax;
    }

    public A withTasksMax(java.lang.Integer tasksMax) {
        this.tasksMax=tasksMax; return (A) this;
    }

    public java.lang.Boolean hasTasksMax() {
        return this.tasksMax != null;
    }

    public java.lang.Boolean getPause() {
        return this.pause;
    }

    public A withPause(java.lang.Boolean pause) {
        this.pause=pause; return (A) this;
    }

    public java.lang.Boolean hasPause() {
        return this.pause != null;
    }

    public A addToConfig(java.lang.String key,java.lang.Object value) {
        if(this.config == null && key != null && value != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null && map != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(java.lang.String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getConfig() {
        return this.config;
    }

    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(config);} return (A) this;
    }

    public java.lang.Boolean hasConfig() {
        return this.config != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AbstractConnectorSpecFluentImpl that = (AbstractConnectorSpecFluentImpl) o;
        if (tasksMax != null ? !tasksMax.equals(that.tasksMax) :that.tasksMax != null) return false;
        if (pause != null ? !pause.equals(that.pause) :that.pause != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(tasksMax,  pause,  config,  super.hashCode());
    }

}
