package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder;
import java.lang.Object;
import io.strimzi.api.kafka.model.tracing.Tracing;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationFluentImpl;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplate;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import java.lang.Integer;
import io.strimzi.api.kafka.model.connect.ExternalConfiguration;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluentImpl;

public class AbstractKafkaConnectSpecFluentImpl<A extends io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluentImpl<A> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent<A> {

    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.Logging,?> logging;
    private java.lang.Integer replicas;
    private java.lang.String version;
    private java.lang.String image;
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;
    private io.strimzi.api.kafka.model.ProbeBuilder livenessProbe;
    private io.strimzi.api.kafka.model.ProbeBuilder readinessProbe;
    private io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder jmxOptions;
    private io.strimzi.api.kafka.model.JvmOptionsBuilder jvmOptions;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.MetricsConfig,?> metricsConfig;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.tracing.Tracing,?> tracing;
    private io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder template;
    private io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder externalConfiguration;

    public AbstractKafkaConnectSpecFluentImpl() {
    }

    public AbstractKafkaConnectSpecFluentImpl(io.strimzi.api.kafka.model.AbstractKafkaConnectSpec instance) {
        this.withLogging(instance.getLogging());
        
        this.withReplicas(instance.getReplicas());
        
        this.withVersion(instance.getVersion());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJmxOptions(instance.getJmxOptions());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withTracing(instance.getTracing());
        
        this.withTemplate(instance.getTemplate());
        
        this.withExternalConfiguration(instance.getExternalConfiguration());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLogging instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Logging getLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public io.strimzi.api.kafka.model.Logging buildLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(io.strimzi.api.kafka.model.Logging logging) {
        if (logging instanceof io.strimzi.api.kafka.model.ExternalLogging){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder((io.strimzi.api.kafka.model.ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
        if (logging instanceof io.strimzi.api.kafka.model.InlineLogging){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder((io.strimzi.api.kafka.model.InlineLogging)logging); _visitables.get("logging").add(this.logging);}
        return (A) this;
    }

    public java.lang.Boolean hasLogging() {
        return this.logging != null;
    }

    public A withExternalLogging(io.strimzi.api.kafka.model.ExternalLogging externalLogging) {
        _visitables.get("logging").remove(this.logging);
        if (externalLogging!=null){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.ExternalLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(io.strimzi.api.kafka.model.ExternalLogging item) {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(io.strimzi.api.kafka.model.InlineLogging inlineLogging) {
        _visitables.get("logging").remove(this.logging);
        if (inlineLogging!=null){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.InlineLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(io.strimzi.api.kafka.model.InlineLogging item) {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.InlineLoggingNestedImpl(item);
    }

    public java.lang.Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(java.lang.Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return this.replicas != null;
    }

    public java.lang.String getVersion() {
        return this.version;
    }

    public A withVersion(java.lang.String version) {
        this.version=version; return (A) this;
    }

    public java.lang.Boolean hasVersion() {
        return this.version != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withVersion instead.
     */
        public A withNewVersion(java.lang.String original) {
        return (A)withVersion(new String(original));
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original) {
        return (A)withImage(new String(original));
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public java.lang.Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.LivenessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.LivenessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public java.lang.Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.ReadinessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.ReadinessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaJmxOptions getJmxOptions() {
        return this.jmxOptions!=null?this.jmxOptions.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaJmxOptions buildJmxOptions() {
        return this.jmxOptions!=null?this.jmxOptions.build():null;
    }

    public A withJmxOptions(io.strimzi.api.kafka.model.KafkaJmxOptions jmxOptions) {
        _visitables.get("jmxOptions").remove(this.jmxOptions);
        if (jmxOptions!=null){ this.jmxOptions= new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder(jmxOptions); _visitables.get("jmxOptions").add(this.jmxOptions);} return (A) this;
    }

    public java.lang.Boolean hasJmxOptions() {
        return this.jmxOptions != null;
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxOptionsNested<A> withNewJmxOptions() {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.JmxOptionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxOptionsNested<A> withNewJmxOptionsLike(io.strimzi.api.kafka.model.KafkaJmxOptions item) {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.JmxOptionsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxOptionsNested<A> editJmxOptions() {
        return withNewJmxOptionsLike(getJmxOptions());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxOptionsNested<A> editOrNewJmxOptions() {
        return withNewJmxOptionsLike(getJmxOptions() != null ? getJmxOptions(): new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder().build());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxOptionsNested<A> editOrNewJmxOptionsLike(io.strimzi.api.kafka.model.KafkaJmxOptions item) {
        return withNewJmxOptionsLike(getJmxOptions() != null ? getJmxOptions(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJvmOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JvmOptions getJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public io.strimzi.api.kafka.model.JvmOptions buildJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(io.strimzi.api.kafka.model.JvmOptions jvmOptions) {
        _visitables.get("jvmOptions").remove(this.jvmOptions);
        if (jvmOptions!=null){ this.jvmOptions= new io.strimzi.api.kafka.model.JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public java.lang.Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.JvmOptionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.JvmOptionsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new io.strimzi.api.kafka.model.JvmOptionsBuilder().build());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetricsConfig instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.MetricsConfig getMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public io.strimzi.api.kafka.model.MetricsConfig buildMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public A withMetricsConfig(io.strimzi.api.kafka.model.MetricsConfig metricsConfig) {
        if (metricsConfig instanceof io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics){ this.metricsConfig= new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder((io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics)metricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);}
        return (A) this;
    }

    public java.lang.Boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public A withJmxPrometheusExporterMetricsConfig(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig) {
        _visitables.get("metricsConfig").remove(this.metricsConfig);
        if (jmxPrometheusExporterMetricsConfig!=null){ this.metricsConfig= new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(jmxPrometheusExporterMetricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);} return (A) this;
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.JmxPrometheusExporterMetricsConfigNestedImpl();
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item) {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.JmxPrometheusExporterMetricsConfigNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTracing instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.tracing.Tracing getTracing() {
        return this.tracing!=null?this.tracing.build():null;
    }

    public io.strimzi.api.kafka.model.tracing.Tracing buildTracing() {
        return this.tracing!=null?this.tracing.build():null;
    }

    public A withTracing(io.strimzi.api.kafka.model.tracing.Tracing tracing) {
        if (tracing instanceof io.strimzi.api.kafka.model.tracing.JaegerTracing){ this.tracing= new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder((io.strimzi.api.kafka.model.tracing.JaegerTracing)tracing); _visitables.get("tracing").add(this.tracing);}
        return (A) this;
    }

    public java.lang.Boolean hasTracing() {
        return this.tracing != null;
    }

    public A withJaegerTracing(io.strimzi.api.kafka.model.tracing.JaegerTracing jaegerTracing) {
        _visitables.get("tracing").remove(this.tracing);
        if (jaegerTracing!=null){ this.tracing= new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder(jaegerTracing); _visitables.get("tracing").add(this.tracing);} return (A) this;
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JaegerTracingNested<A> withNewJaegerTracing() {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.JaegerTracingNestedImpl();
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JaegerTracingNested<A> withNewJaegerTracingLike(io.strimzi.api.kafka.model.tracing.JaegerTracing item) {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.JaegerTracingNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.KafkaConnectTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.strimzi.api.kafka.model.template.KafkaConnectTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.TemplateNestedImpl();
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaConnectTemplate item) {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaConnectTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildExternalConfiguration instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.connect.ExternalConfiguration getExternalConfiguration() {
        return this.externalConfiguration!=null?this.externalConfiguration.build():null;
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfiguration buildExternalConfiguration() {
        return this.externalConfiguration!=null?this.externalConfiguration.build():null;
    }

    public A withExternalConfiguration(io.strimzi.api.kafka.model.connect.ExternalConfiguration externalConfiguration) {
        _visitables.get("externalConfiguration").remove(this.externalConfiguration);
        if (externalConfiguration!=null){ this.externalConfiguration= new io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder(externalConfiguration); _visitables.get("externalConfiguration").add(this.externalConfiguration);} return (A) this;
    }

    public java.lang.Boolean hasExternalConfiguration() {
        return this.externalConfiguration != null;
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalConfigurationNested<A> withNewExternalConfiguration() {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.ExternalConfigurationNestedImpl();
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalConfigurationNested<A> withNewExternalConfigurationLike(io.strimzi.api.kafka.model.connect.ExternalConfiguration item) {
        return new io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl.ExternalConfigurationNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalConfigurationNested<A> editExternalConfiguration() {
        return withNewExternalConfigurationLike(getExternalConfiguration());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalConfigurationNested<A> editOrNewExternalConfiguration() {
        return withNewExternalConfigurationLike(getExternalConfiguration() != null ? getExternalConfiguration(): new io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder().build());
    }

    public io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalConfigurationNested<A> editOrNewExternalConfigurationLike(io.strimzi.api.kafka.model.connect.ExternalConfiguration item) {
        return withNewExternalConfigurationLike(getExternalConfiguration() != null ? getExternalConfiguration(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AbstractKafkaConnectSpecFluentImpl that = (AbstractKafkaConnectSpecFluentImpl) o;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        if (jmxOptions != null ? !jmxOptions.equals(that.jmxOptions) :that.jmxOptions != null) return false;
        if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
        if (metricsConfig != null ? !metricsConfig.equals(that.metricsConfig) :that.metricsConfig != null) return false;
        if (tracing != null ? !tracing.equals(that.tracing) :that.tracing != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        if (externalConfiguration != null ? !externalConfiguration.equals(that.externalConfiguration) :that.externalConfiguration != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(logging,  replicas,  version,  image,  resources,  livenessProbe,  readinessProbe,  jmxOptions,  jvmOptions,  metricsConfig,  tracing,  template,  externalConfiguration,  super.hashCode());
    }

      
  /**
   * Logging config comes from an existing, user-supplied config map
   */
  public class ExternalLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.ExternalLoggingFluentImpl<io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalLoggingNested<N>> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ExternalLoggingBuilder builder;

            ExternalLoggingNestedImpl(io.strimzi.api.kafka.model.ExternalLogging item) {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this, item);
                        
            }

            ExternalLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) AbstractKafkaConnectSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endExternalLogging() {
                return and();
            }
    }


      
  /**
   * Logging config is given inline with the resource
   */
  public class InlineLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.InlineLoggingFluentImpl<io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.InlineLoggingNested<N>> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.InlineLoggingBuilder builder;

            InlineLoggingNestedImpl(io.strimzi.api.kafka.model.InlineLogging item) {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this, item);
                        
            }

            InlineLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) AbstractKafkaConnectSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endInlineLogging() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class LivenessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.LivenessProbeNested<N>> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            LivenessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) AbstractKafkaConnectSpecFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class ReadinessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ReadinessProbeNested<N>> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            ReadinessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) AbstractKafkaConnectSpecFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


    public class JmxOptionsNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaJmxOptionsFluentImpl<io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxOptionsNested<N>> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder builder;

            JmxOptionsNestedImpl(io.strimzi.api.kafka.model.KafkaJmxOptions item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder(this, item);
                        
            }

            JmxOptionsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) AbstractKafkaConnectSpecFluentImpl.this.withJmxOptions(builder.build());
            }

            public N endJmxOptions() {
                return and();
            }
    }


      
  /**
   * Representation for options to be passed to a JVM.
   */
  public class JvmOptionsNestedImpl<N> extends io.strimzi.api.kafka.model.JvmOptionsFluentImpl<io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JvmOptionsNested<N>> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JvmOptionsBuilder builder;

            JvmOptionsNestedImpl(io.strimzi.api.kafka.model.JvmOptions item) {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this, item);
                        
            }

            JvmOptionsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) AbstractKafkaConnectSpecFluentImpl.this.withJvmOptions(builder.build());
            }

            public N endJvmOptions() {
                return and();
            }
    }


      
  /**
   * JMX Prometheus Exporter metrics config
   */
  public class JmxPrometheusExporterMetricsConfigNestedImpl<N> extends io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluentImpl<io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder builder;

            JmxPrometheusExporterMetricsConfigNestedImpl(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item) {
                this.builder = new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(this, item);
                        
            }

            JmxPrometheusExporterMetricsConfigNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(this);
                        
            }

            public N and() {
                return (N) AbstractKafkaConnectSpecFluentImpl.this.withMetricsConfig(builder.build());
            }

            public N endJmxPrometheusExporterMetricsConfig() {
                return and();
            }
    }


      
  /**
   * Configures the tracing using the Jaeger OpenTracing implementation
   */
  public class JaegerTracingNestedImpl<N> extends io.strimzi.api.kafka.model.tracing.JaegerTracingFluentImpl<io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JaegerTracingNested<N>> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.JaegerTracingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder builder;

            JaegerTracingNestedImpl(io.strimzi.api.kafka.model.tracing.JaegerTracing item) {
                this.builder = new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder(this, item);
                        
            }

            JaegerTracingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder(this);
                        
            }

            public N and() {
                return (N) AbstractKafkaConnectSpecFluentImpl.this.withTracing(builder.build());
            }

            public N endJaegerTracing() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Kafka Connect resources.
   */
  public class TemplateNestedImpl<N> extends io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl<io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.TemplateNested<N>> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder builder;

            TemplateNestedImpl(io.strimzi.api.kafka.model.template.KafkaConnectTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) AbstractKafkaConnectSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


      
  /**
   * Representation for external configuration for Kafka Connect connectors passed from Secrets or ConfigMaps
   */
  public class ExternalConfigurationNestedImpl<N> extends io.strimzi.api.kafka.model.connect.ExternalConfigurationFluentImpl<io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalConfigurationNested<N>> implements io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent.ExternalConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder builder;

            ExternalConfigurationNestedImpl(io.strimzi.api.kafka.model.connect.ExternalConfiguration item) {
                this.builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder(this, item);
                        
            }

            ExternalConfigurationNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder(this);
                        
            }

            public N and() {
                return (N) AbstractKafkaConnectSpecFluentImpl.this.withExternalConfiguration(builder.build());
            }

            public N endExternalConfiguration() {
                return and();
            }
    }


}
