package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * A representation of a single ACL rule for AclAuthorizer
   */
  public class AclRuleBuilder extends io.strimzi.api.kafka.model.AclRuleFluentImpl<io.strimzi.api.kafka.model.AclRuleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.AclRule,io.strimzi.api.kafka.model.AclRuleBuilder> {

    io.strimzi.api.kafka.model.AclRuleFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public AclRuleBuilder() {
        this(true);
    }

    public AclRuleBuilder(java.lang.Boolean validationEnabled) {
        this(new AclRule(), validationEnabled);
    }

    public AclRuleBuilder(io.strimzi.api.kafka.model.AclRuleFluent<?> fluent) {
        this(fluent, true);
    }

    public AclRuleBuilder(io.strimzi.api.kafka.model.AclRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new AclRule(), validationEnabled);
    }

    public AclRuleBuilder(io.strimzi.api.kafka.model.AclRuleFluent<?> fluent,io.strimzi.api.kafka.model.AclRule instance) {
        this(fluent, instance, true);
    }

    public AclRuleBuilder(io.strimzi.api.kafka.model.AclRuleFluent<?> fluent,io.strimzi.api.kafka.model.AclRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withType(instance.getType()); 
        fluent.withResource(instance.getResource()); 
        fluent.withHost(instance.getHost()); 
        fluent.withOperation(instance.getOperation()); 
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleBuilder(io.strimzi.api.kafka.model.AclRule instance) {
        this(instance,true);
    }

    public AclRuleBuilder(io.strimzi.api.kafka.model.AclRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withType(instance.getType()); 
        this.withResource(instance.getResource()); 
        this.withHost(instance.getHost()); 
        this.withOperation(instance.getOperation()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.AclRule build() {
        AclRule buildable = new AclRule(fluent.getType(),fluent.getResource(),fluent.getHost(),fluent.getOperation());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AclRuleBuilder that = (AclRuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
