package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

  
  /**
   * A representation of a single ACL rule for AclAuthorizer
   */
  public class AclRuleFluentImpl<A extends io.strimzi.api.kafka.model.AclRuleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.AclRuleFluent<A> {

    private io.strimzi.api.kafka.model.AclRuleType type;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.AclRuleResource,?> resource;
    private java.lang.String host;
    private io.strimzi.api.kafka.model.AclOperation operation;

    public AclRuleFluentImpl() {
    }

    public AclRuleFluentImpl(io.strimzi.api.kafka.model.AclRule instance) {
        this.withType(instance.getType()); 
        this.withResource(instance.getResource()); 
        this.withHost(instance.getHost()); 
        this.withOperation(instance.getOperation()); 
    }

    public io.strimzi.api.kafka.model.AclRuleType getType() {
        return this.type;
    }

    public A withType(io.strimzi.api.kafka.model.AclRuleType type) {
        this.type=type; return (A) this;
    }

    public java.lang.Boolean hasType() {
        return this.type != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildResource instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.AclRuleResource getResource() {
        return this.resource!=null?this.resource.build():null;
    }

    public io.strimzi.api.kafka.model.AclRuleResource buildResource() {
        return this.resource!=null?this.resource.build():null;
    }

    public A withResource(io.strimzi.api.kafka.model.AclRuleResource resource) {
        if (resource instanceof io.strimzi.api.kafka.model.AclRuleGroupResource){ this.resource= new io.strimzi.api.kafka.model.AclRuleGroupResourceBuilder((io.strimzi.api.kafka.model.AclRuleGroupResource)resource); _visitables.get("resource").add(this.resource);}
        if (resource instanceof io.strimzi.api.kafka.model.AclRuleTopicResource){ this.resource= new io.strimzi.api.kafka.model.AclRuleTopicResourceBuilder((io.strimzi.api.kafka.model.AclRuleTopicResource)resource); _visitables.get("resource").add(this.resource);}
        if (resource instanceof io.strimzi.api.kafka.model.AclRuleTransactionalIdResource){ this.resource= new io.strimzi.api.kafka.model.AclRuleTransactionalIdResourceBuilder((io.strimzi.api.kafka.model.AclRuleTransactionalIdResource)resource); _visitables.get("resource").add(this.resource);}
        if (resource instanceof io.strimzi.api.kafka.model.AclRuleClusterResource){ this.resource= new io.strimzi.api.kafka.model.AclRuleClusterResourceBuilder((io.strimzi.api.kafka.model.AclRuleClusterResource)resource); _visitables.get("resource").add(this.resource);}
        return (A) this;
    }

    public java.lang.Boolean hasResource() {
        return this.resource != null;
    }

    public A withAclRuleGroupResource(io.strimzi.api.kafka.model.AclRuleGroupResource aclRuleGroupResource) {
        _visitables.get("resource").remove(this.resource);
        if (aclRuleGroupResource!=null){ this.resource= new io.strimzi.api.kafka.model.AclRuleGroupResourceBuilder(aclRuleGroupResource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public io.strimzi.api.kafka.model.AclRuleFluent.AclRuleGroupResourceNested<A> withNewAclRuleGroupResource() {
        return new io.strimzi.api.kafka.model.AclRuleFluentImpl.AclRuleGroupResourceNestedImpl();
    }

    public io.strimzi.api.kafka.model.AclRuleFluent.AclRuleGroupResourceNested<A> withNewAclRuleGroupResourceLike(io.strimzi.api.kafka.model.AclRuleGroupResource item) {
        return new io.strimzi.api.kafka.model.AclRuleFluentImpl.AclRuleGroupResourceNestedImpl(item);
    }

    public A withAclRuleTopicResource(io.strimzi.api.kafka.model.AclRuleTopicResource aclRuleTopicResource) {
        _visitables.get("resource").remove(this.resource);
        if (aclRuleTopicResource!=null){ this.resource= new io.strimzi.api.kafka.model.AclRuleTopicResourceBuilder(aclRuleTopicResource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public io.strimzi.api.kafka.model.AclRuleFluent.AclRuleTopicResourceNested<A> withNewAclRuleTopicResource() {
        return new io.strimzi.api.kafka.model.AclRuleFluentImpl.AclRuleTopicResourceNestedImpl();
    }

    public io.strimzi.api.kafka.model.AclRuleFluent.AclRuleTopicResourceNested<A> withNewAclRuleTopicResourceLike(io.strimzi.api.kafka.model.AclRuleTopicResource item) {
        return new io.strimzi.api.kafka.model.AclRuleFluentImpl.AclRuleTopicResourceNestedImpl(item);
    }

    public A withAclRuleTransactionalIdResource(io.strimzi.api.kafka.model.AclRuleTransactionalIdResource aclRuleTransactionalIdResource) {
        _visitables.get("resource").remove(this.resource);
        if (aclRuleTransactionalIdResource!=null){ this.resource= new io.strimzi.api.kafka.model.AclRuleTransactionalIdResourceBuilder(aclRuleTransactionalIdResource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public io.strimzi.api.kafka.model.AclRuleFluent.AclRuleTransactionalIdResourceNested<A> withNewAclRuleTransactionalIdResource() {
        return new io.strimzi.api.kafka.model.AclRuleFluentImpl.AclRuleTransactionalIdResourceNestedImpl();
    }

    public io.strimzi.api.kafka.model.AclRuleFluent.AclRuleTransactionalIdResourceNested<A> withNewAclRuleTransactionalIdResourceLike(io.strimzi.api.kafka.model.AclRuleTransactionalIdResource item) {
        return new io.strimzi.api.kafka.model.AclRuleFluentImpl.AclRuleTransactionalIdResourceNestedImpl(item);
    }

    public A withAclRuleClusterResource(io.strimzi.api.kafka.model.AclRuleClusterResource aclRuleClusterResource) {
        _visitables.get("resource").remove(this.resource);
        if (aclRuleClusterResource!=null){ this.resource= new io.strimzi.api.kafka.model.AclRuleClusterResourceBuilder(aclRuleClusterResource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public io.strimzi.api.kafka.model.AclRuleFluent.AclRuleClusterResourceNested<A> withNewAclRuleClusterResource() {
        return new io.strimzi.api.kafka.model.AclRuleFluentImpl.AclRuleClusterResourceNestedImpl();
    }

    public io.strimzi.api.kafka.model.AclRuleFluent.AclRuleClusterResourceNested<A> withNewAclRuleClusterResourceLike(io.strimzi.api.kafka.model.AclRuleClusterResource item) {
        return new io.strimzi.api.kafka.model.AclRuleFluentImpl.AclRuleClusterResourceNestedImpl(item);
    }

    public java.lang.String getHost() {
        return this.host;
    }

    public A withHost(java.lang.String host) {
        this.host=host; return (A) this;
    }

    public java.lang.Boolean hasHost() {
        return this.host != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHost instead.
     */
        public A withNewHost(java.lang.String original) {
        return (A)withHost(new String(original));
    }

    public io.strimzi.api.kafka.model.AclOperation getOperation() {
        return this.operation;
    }

    public A withOperation(io.strimzi.api.kafka.model.AclOperation operation) {
        this.operation=operation; return (A) this;
    }

    public java.lang.Boolean hasOperation() {
        return this.operation != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AclRuleFluentImpl that = (AclRuleFluentImpl) o;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        if (operation != null ? !operation.equals(that.operation) :that.operation != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(type,  resource,  host,  operation,  super.hashCode());
    }

      
  /**
   * A representation of a group resource for ACLs
   */
  public class AclRuleGroupResourceNestedImpl<N> extends io.strimzi.api.kafka.model.AclRuleGroupResourceFluentImpl<io.strimzi.api.kafka.model.AclRuleFluent.AclRuleGroupResourceNested<N>> implements io.strimzi.api.kafka.model.AclRuleFluent.AclRuleGroupResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.AclRuleGroupResourceBuilder builder;

            AclRuleGroupResourceNestedImpl(io.strimzi.api.kafka.model.AclRuleGroupResource item) {
                this.builder = new io.strimzi.api.kafka.model.AclRuleGroupResourceBuilder(this, item);
                        
            }

            AclRuleGroupResourceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.AclRuleGroupResourceBuilder(this);
                        
            }

            public N and() {
                return (N) AclRuleFluentImpl.this.withResource(builder.build());
            }

            public N endAclRuleGroupResource() {
                return and();
            }
    }


      
  /**
   * A representation of a topic resource for ACLs
   */
  public class AclRuleTopicResourceNestedImpl<N> extends io.strimzi.api.kafka.model.AclRuleTopicResourceFluentImpl<io.strimzi.api.kafka.model.AclRuleFluent.AclRuleTopicResourceNested<N>> implements io.strimzi.api.kafka.model.AclRuleFluent.AclRuleTopicResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.AclRuleTopicResourceBuilder builder;

            AclRuleTopicResourceNestedImpl(io.strimzi.api.kafka.model.AclRuleTopicResource item) {
                this.builder = new io.strimzi.api.kafka.model.AclRuleTopicResourceBuilder(this, item);
                        
            }

            AclRuleTopicResourceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.AclRuleTopicResourceBuilder(this);
                        
            }

            public N and() {
                return (N) AclRuleFluentImpl.this.withResource(builder.build());
            }

            public N endAclRuleTopicResource() {
                return and();
            }
    }


      
  /**
   * A representation of a transactional ID resource for ACLs
   */
  public class AclRuleTransactionalIdResourceNestedImpl<N> extends io.strimzi.api.kafka.model.AclRuleTransactionalIdResourceFluentImpl<io.strimzi.api.kafka.model.AclRuleFluent.AclRuleTransactionalIdResourceNested<N>> implements io.strimzi.api.kafka.model.AclRuleFluent.AclRuleTransactionalIdResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.AclRuleTransactionalIdResourceBuilder builder;

            AclRuleTransactionalIdResourceNestedImpl(io.strimzi.api.kafka.model.AclRuleTransactionalIdResource item) {
                this.builder = new io.strimzi.api.kafka.model.AclRuleTransactionalIdResourceBuilder(this, item);
                        
            }

            AclRuleTransactionalIdResourceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.AclRuleTransactionalIdResourceBuilder(this);
                        
            }

            public N and() {
                return (N) AclRuleFluentImpl.this.withResource(builder.build());
            }

            public N endAclRuleTransactionalIdResource() {
                return and();
            }
    }


      
  /**
   * A representation of a cluster resource for ACLs
   */
  public class AclRuleClusterResourceNestedImpl<N> extends io.strimzi.api.kafka.model.AclRuleClusterResourceFluentImpl<io.strimzi.api.kafka.model.AclRuleFluent.AclRuleClusterResourceNested<N>> implements io.strimzi.api.kafka.model.AclRuleFluent.AclRuleClusterResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.AclRuleClusterResourceBuilder builder;

            AclRuleClusterResourceNestedImpl(io.strimzi.api.kafka.model.AclRuleClusterResource item) {
                this.builder = new io.strimzi.api.kafka.model.AclRuleClusterResourceBuilder(this, item);
                        
            }

            AclRuleClusterResourceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.AclRuleClusterResourceBuilder(this);
                        
            }

            public N and() {
                return (N) AclRuleFluentImpl.this.withResource(builder.build());
            }

            public N endAclRuleClusterResource() {
                return and();
            }
    }


}
