package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * A representation of a group resource for ACLs
   */
  public class AclRuleGroupResourceBuilder extends io.strimzi.api.kafka.model.AclRuleGroupResourceFluentImpl<io.strimzi.api.kafka.model.AclRuleGroupResourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.AclRuleGroupResource,io.strimzi.api.kafka.model.AclRuleGroupResourceBuilder> {

    io.strimzi.api.kafka.model.AclRuleGroupResourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public AclRuleGroupResourceBuilder() {
        this(true);
    }

    public AclRuleGroupResourceBuilder(java.lang.Boolean validationEnabled) {
        this(new AclRuleGroupResource(), validationEnabled);
    }

    public AclRuleGroupResourceBuilder(io.strimzi.api.kafka.model.AclRuleGroupResourceFluent<?> fluent) {
        this(fluent, true);
    }

    public AclRuleGroupResourceBuilder(io.strimzi.api.kafka.model.AclRuleGroupResourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new AclRuleGroupResource(), validationEnabled);
    }

    public AclRuleGroupResourceBuilder(io.strimzi.api.kafka.model.AclRuleGroupResourceFluent<?> fluent,io.strimzi.api.kafka.model.AclRuleGroupResource instance) {
        this(fluent, instance, true);
    }

    public AclRuleGroupResourceBuilder(io.strimzi.api.kafka.model.AclRuleGroupResourceFluent<?> fluent,io.strimzi.api.kafka.model.AclRuleGroupResource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withPatternType(instance.getPatternType());
        
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleGroupResourceBuilder(io.strimzi.api.kafka.model.AclRuleGroupResource instance) {
        this(instance,true);
    }

    public AclRuleGroupResourceBuilder(io.strimzi.api.kafka.model.AclRuleGroupResource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withPatternType(instance.getPatternType());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.AclRuleGroupResource build() {
        AclRuleGroupResource buildable = new AclRuleGroupResource();
        buildable.setName(fluent.getName());
        buildable.setPatternType(fluent.getPatternType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AclRuleGroupResourceBuilder that = (AclRuleGroupResourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
