package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * A representation of a topic resource for ACLs
   */
  public class AclRuleTopicResourceBuilder extends io.strimzi.api.kafka.model.AclRuleTopicResourceFluentImpl<io.strimzi.api.kafka.model.AclRuleTopicResourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.AclRuleTopicResource,io.strimzi.api.kafka.model.AclRuleTopicResourceBuilder> {

    io.strimzi.api.kafka.model.AclRuleTopicResourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public AclRuleTopicResourceBuilder() {
        this(true);
    }

    public AclRuleTopicResourceBuilder(java.lang.Boolean validationEnabled) {
        this(new AclRuleTopicResource(), validationEnabled);
    }

    public AclRuleTopicResourceBuilder(io.strimzi.api.kafka.model.AclRuleTopicResourceFluent<?> fluent) {
        this(fluent, true);
    }

    public AclRuleTopicResourceBuilder(io.strimzi.api.kafka.model.AclRuleTopicResourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new AclRuleTopicResource(), validationEnabled);
    }

    public AclRuleTopicResourceBuilder(io.strimzi.api.kafka.model.AclRuleTopicResourceFluent<?> fluent,io.strimzi.api.kafka.model.AclRuleTopicResource instance) {
        this(fluent, instance, true);
    }

    public AclRuleTopicResourceBuilder(io.strimzi.api.kafka.model.AclRuleTopicResourceFluent<?> fluent,io.strimzi.api.kafka.model.AclRuleTopicResource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withPatternType(instance.getPatternType());
        
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleTopicResourceBuilder(io.strimzi.api.kafka.model.AclRuleTopicResource instance) {
        this(instance,true);
    }

    public AclRuleTopicResourceBuilder(io.strimzi.api.kafka.model.AclRuleTopicResource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withPatternType(instance.getPatternType());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.AclRuleTopicResource build() {
        AclRuleTopicResource buildable = new AclRuleTopicResource();
        buildable.setName(fluent.getName());
        buildable.setPatternType(fluent.getPatternType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AclRuleTopicResourceBuilder that = (AclRuleTopicResourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
