package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a certificate and private key pair inside a Secret
   */
  public class CertAndKeySecretSourceBuilder extends io.strimzi.api.kafka.model.CertAndKeySecretSourceFluentImpl<io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.CertAndKeySecretSource,io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder> {

    io.strimzi.api.kafka.model.CertAndKeySecretSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CertAndKeySecretSourceBuilder() {
        this(true);
    }

    public CertAndKeySecretSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new CertAndKeySecretSource(), validationEnabled);
    }

    public CertAndKeySecretSourceBuilder(io.strimzi.api.kafka.model.CertAndKeySecretSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public CertAndKeySecretSourceBuilder(io.strimzi.api.kafka.model.CertAndKeySecretSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CertAndKeySecretSource(), validationEnabled);
    }

    public CertAndKeySecretSourceBuilder(io.strimzi.api.kafka.model.CertAndKeySecretSourceFluent<?> fluent,io.strimzi.api.kafka.model.CertAndKeySecretSource instance) {
        this(fluent, instance, true);
    }

    public CertAndKeySecretSourceBuilder(io.strimzi.api.kafka.model.CertAndKeySecretSourceFluent<?> fluent,io.strimzi.api.kafka.model.CertAndKeySecretSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withKey(instance.getKey());
        
        fluent.withSecretName(instance.getSecretName());
        
        fluent.withCertificate(instance.getCertificate());
        
        this.validationEnabled = validationEnabled; 
    }

    public CertAndKeySecretSourceBuilder(io.strimzi.api.kafka.model.CertAndKeySecretSource instance) {
        this(instance,true);
    }

    public CertAndKeySecretSourceBuilder(io.strimzi.api.kafka.model.CertAndKeySecretSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withKey(instance.getKey());
        
        this.withSecretName(instance.getSecretName());
        
        this.withCertificate(instance.getCertificate());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.CertAndKeySecretSource build() {
        CertAndKeySecretSource buildable = new CertAndKeySecretSource();
        buildable.setSecretName(fluent.getSecretName());
        buildable.setCertificate(fluent.getCertificate());
        buildable.setKey(fluent.getKey());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CertAndKeySecretSourceBuilder that = (CertAndKeySecretSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
