package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a certificate inside a Secret
   */
  public class CertSecretSourceBuilder extends io.strimzi.api.kafka.model.CertSecretSourceFluentImpl<io.strimzi.api.kafka.model.CertSecretSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.CertSecretSource,io.strimzi.api.kafka.model.CertSecretSourceBuilder> {

    io.strimzi.api.kafka.model.CertSecretSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CertSecretSourceBuilder() {
        this(true);
    }

    public CertSecretSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new CertSecretSource(), validationEnabled);
    }

    public CertSecretSourceBuilder(io.strimzi.api.kafka.model.CertSecretSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public CertSecretSourceBuilder(io.strimzi.api.kafka.model.CertSecretSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CertSecretSource(), validationEnabled);
    }

    public CertSecretSourceBuilder(io.strimzi.api.kafka.model.CertSecretSourceFluent<?> fluent,io.strimzi.api.kafka.model.CertSecretSource instance) {
        this(fluent, instance, true);
    }

    public CertSecretSourceBuilder(io.strimzi.api.kafka.model.CertSecretSourceFluent<?> fluent,io.strimzi.api.kafka.model.CertSecretSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSecretName(instance.getSecretName());
        
        fluent.withCertificate(instance.getCertificate());
        
        this.validationEnabled = validationEnabled; 
    }

    public CertSecretSourceBuilder(io.strimzi.api.kafka.model.CertSecretSource instance) {
        this(instance,true);
    }

    public CertSecretSourceBuilder(io.strimzi.api.kafka.model.CertSecretSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSecretName(instance.getSecretName());
        
        this.withCertificate(instance.getCertificate());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.CertSecretSource build() {
        CertSecretSource buildable = new CertSecretSource();
        buildable.setSecretName(fluent.getSecretName());
        buildable.setCertificate(fluent.getCertificate());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CertSecretSourceBuilder that = (CertSecretSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
