package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CertificateAuthorityBuilder extends io.strimzi.api.kafka.model.CertificateAuthorityFluentImpl<io.strimzi.api.kafka.model.CertificateAuthorityBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.CertificateAuthority,io.strimzi.api.kafka.model.CertificateAuthorityBuilder> {

    io.strimzi.api.kafka.model.CertificateAuthorityFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CertificateAuthorityBuilder() {
        this(true);
    }

    public CertificateAuthorityBuilder(java.lang.Boolean validationEnabled) {
        this(new CertificateAuthority(), validationEnabled);
    }

    public CertificateAuthorityBuilder(io.strimzi.api.kafka.model.CertificateAuthorityFluent<?> fluent) {
        this(fluent, true);
    }

    public CertificateAuthorityBuilder(io.strimzi.api.kafka.model.CertificateAuthorityFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CertificateAuthority(), validationEnabled);
    }

    public CertificateAuthorityBuilder(io.strimzi.api.kafka.model.CertificateAuthorityFluent<?> fluent,io.strimzi.api.kafka.model.CertificateAuthority instance) {
        this(fluent, instance, true);
    }

    public CertificateAuthorityBuilder(io.strimzi.api.kafka.model.CertificateAuthorityFluent<?> fluent,io.strimzi.api.kafka.model.CertificateAuthority instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withValidityDays(instance.getValidityDays());
        
        fluent.withGenerateCertificateAuthority(instance.isGenerateCertificateAuthority());
        
        fluent.withGenerateSecretOwnerReference(instance.isGenerateSecretOwnerReference());
        
        fluent.withRenewalDays(instance.getRenewalDays());
        
        fluent.withCertificateExpirationPolicy(instance.getCertificateExpirationPolicy());
        
        this.validationEnabled = validationEnabled; 
    }

    public CertificateAuthorityBuilder(io.strimzi.api.kafka.model.CertificateAuthority instance) {
        this(instance,true);
    }

    public CertificateAuthorityBuilder(io.strimzi.api.kafka.model.CertificateAuthority instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withValidityDays(instance.getValidityDays());
        
        this.withGenerateCertificateAuthority(instance.isGenerateCertificateAuthority());
        
        this.withGenerateSecretOwnerReference(instance.isGenerateSecretOwnerReference());
        
        this.withRenewalDays(instance.getRenewalDays());
        
        this.withCertificateExpirationPolicy(instance.getCertificateExpirationPolicy());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.CertificateAuthority build() {
        CertificateAuthority buildable = new CertificateAuthority();
        buildable.setValidityDays(fluent.getValidityDays());
        buildable.setGenerateCertificateAuthority(fluent.isGenerateCertificateAuthority());
        buildable.setGenerateSecretOwnerReference(fluent.isGenerateSecretOwnerReference());
        buildable.setRenewalDays(fluent.getRenewalDays());
        buildable.setCertificateExpirationPolicy(fluent.getCertificateExpirationPolicy());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CertificateAuthorityBuilder that = (CertificateAuthorityBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
