package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represent the TLS configuration for all the Clients(KafkaConnect, KafkaBridge, KafkaMirrorMaker, KafkaMirrorMaker2).
   */
  public class ClientTlsBuilder extends io.strimzi.api.kafka.model.ClientTlsFluentImpl<io.strimzi.api.kafka.model.ClientTlsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.ClientTls,io.strimzi.api.kafka.model.ClientTlsBuilder> {

    io.strimzi.api.kafka.model.ClientTlsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClientTlsBuilder() {
        this(true);
    }

    public ClientTlsBuilder(java.lang.Boolean validationEnabled) {
        this(new ClientTls(), validationEnabled);
    }

    public ClientTlsBuilder(io.strimzi.api.kafka.model.ClientTlsFluent<?> fluent) {
        this(fluent, true);
    }

    public ClientTlsBuilder(io.strimzi.api.kafka.model.ClientTlsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClientTls(), validationEnabled);
    }

    public ClientTlsBuilder(io.strimzi.api.kafka.model.ClientTlsFluent<?> fluent,io.strimzi.api.kafka.model.ClientTls instance) {
        this(fluent, instance, true);
    }

    public ClientTlsBuilder(io.strimzi.api.kafka.model.ClientTlsFluent<?> fluent,io.strimzi.api.kafka.model.ClientTls instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTrustedCertificates(instance.getTrustedCertificates());
        
        this.validationEnabled = validationEnabled; 
    }

    public ClientTlsBuilder(io.strimzi.api.kafka.model.ClientTls instance) {
        this(instance,true);
    }

    public ClientTlsBuilder(io.strimzi.api.kafka.model.ClientTls instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withTrustedCertificates(instance.getTrustedCertificates());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.ClientTls build() {
        ClientTls buildable = new ClientTls();
        buildable.setTrustedCertificates(fluent.getTrustedCertificates());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClientTlsBuilder that = (ClientTlsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
