package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Represent the TLS configuration for all the Clients(KafkaConnect, KafkaBridge, KafkaMirrorMaker, KafkaMirrorMaker2).
   */
  public class ClientTlsFluentImpl<A extends io.strimzi.api.kafka.model.ClientTlsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.ClientTlsFluent<A> {

    private java.util.List<io.strimzi.api.kafka.model.CertSecretSourceBuilder> trustedCertificates;

    public ClientTlsFluentImpl() {
    }

    public ClientTlsFluentImpl(io.strimzi.api.kafka.model.ClientTls instance) {
        this.withTrustedCertificates(instance.getTrustedCertificates());
    }

    public A addToTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        if (this.trustedCertificates == null) {this.trustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").add(index >= 0 ? index : _visitables.get("trustedCertificates").size(), builder);this.trustedCertificates.add(index >= 0 ? index : trustedCertificates.size(), builder); return (A)this;
    }

    public A setToTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        if (this.trustedCertificates == null) {this.trustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("trustedCertificates").size()) { _visitables.get("trustedCertificates").add(builder); } else { _visitables.get("trustedCertificates").set(index, builder);}
        if (index < 0 || index >= trustedCertificates.size()) { trustedCertificates.add(builder); } else { trustedCertificates.set(index, builder);}
         return (A)this;
    }

    public A addToTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items) {
        if (this.trustedCertificates == null) {this.trustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").add(builder);this.trustedCertificates.add(builder);} return (A)this;
    }

    public A addAllToTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items) {
        if (this.trustedCertificates == null) {this.trustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").add(builder);this.trustedCertificates.add(builder);} return (A)this;
    }

    public A removeFromTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items) {
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").remove(builder);if (this.trustedCertificates != null) {this.trustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items) {
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").remove(builder);if (this.trustedCertificates != null) {this.trustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTrustedCertificates(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        if (trustedCertificates == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.CertSecretSourceBuilder> each = trustedCertificates.iterator();
        final List visitables = _visitables.get("trustedCertificates");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTrustedCertificates instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> getTrustedCertificates() {
        return build(trustedCertificates);
    }

    public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> buildTrustedCertificates() {
        return build(trustedCertificates);
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildTrustedCertificate(int index) {
        return this.trustedCertificates.get(index).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildFirstTrustedCertificate() {
        return this.trustedCertificates.get(0).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildLastTrustedCertificate() {
        return this.trustedCertificates.get(trustedCertificates.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildMatchingTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.CertSecretSourceBuilder item: trustedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.CertSecretSourceBuilder item: trustedCertificates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTrustedCertificates(java.util.List<io.strimzi.api.kafka.model.CertSecretSource> trustedCertificates) {
        if (this.trustedCertificates != null) { _visitables.get("trustedCertificates").removeAll(this.trustedCertificates);}
        if (trustedCertificates != null) {this.trustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>(); for (io.strimzi.api.kafka.model.CertSecretSource item : trustedCertificates){this.addToTrustedCertificates(item);}} else { this.trustedCertificates = null;} return (A) this;
    }

    public A withTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... trustedCertificates) {
        if (this.trustedCertificates != null) {this.trustedCertificates.clear();}
        if (trustedCertificates != null) {for (io.strimzi.api.kafka.model.CertSecretSource item :trustedCertificates){ this.addToTrustedCertificates(item);}} return (A) this;
    }

    public java.lang.Boolean hasTrustedCertificates() {
        return trustedCertificates != null && !trustedCertificates.isEmpty();
    }

    public io.strimzi.api.kafka.model.ClientTlsFluent.TrustedCertificatesNested<A> addNewTrustedCertificate() {
        return new io.strimzi.api.kafka.model.ClientTlsFluentImpl.TrustedCertificatesNestedImpl();
    }

    public io.strimzi.api.kafka.model.ClientTlsFluent.TrustedCertificatesNested<A> addNewTrustedCertificateLike(io.strimzi.api.kafka.model.CertSecretSource item) {
        return new io.strimzi.api.kafka.model.ClientTlsFluentImpl.TrustedCertificatesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.ClientTlsFluent.TrustedCertificatesNested<A> setNewTrustedCertificateLike(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        return new io.strimzi.api.kafka.model.ClientTlsFluentImpl.TrustedCertificatesNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.ClientTlsFluent.TrustedCertificatesNested<A> editTrustedCertificate(int index) {
        if (trustedCertificates.size() <= index) throw new RuntimeException("Can't edit trustedCertificates. Index exceeds size.");
        return setNewTrustedCertificateLike(index, buildTrustedCertificate(index));
    }

    public io.strimzi.api.kafka.model.ClientTlsFluent.TrustedCertificatesNested<A> editFirstTrustedCertificate() {
        if (trustedCertificates.size() == 0) throw new RuntimeException("Can't edit first trustedCertificates. The list is empty.");
        return setNewTrustedCertificateLike(0, buildTrustedCertificate(0));
    }

    public io.strimzi.api.kafka.model.ClientTlsFluent.TrustedCertificatesNested<A> editLastTrustedCertificate() {
        int index = trustedCertificates.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last trustedCertificates. The list is empty.");
        return setNewTrustedCertificateLike(index, buildTrustedCertificate(index));
    }

    public io.strimzi.api.kafka.model.ClientTlsFluent.TrustedCertificatesNested<A> editMatchingTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<trustedCertificates.size();i++) { 
        if (predicate.test(trustedCertificates.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching trustedCertificates. No match found.");
        return setNewTrustedCertificateLike(index, buildTrustedCertificate(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClientTlsFluentImpl that = (ClientTlsFluentImpl) o;
        if (trustedCertificates != null ? !trustedCertificates.equals(that.trustedCertificates) :that.trustedCertificates != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(trustedCertificates,  super.hashCode());
    }

      
  /**
   * Represents a certificate inside a Secret
   */
  public class TrustedCertificatesNestedImpl<N> extends io.strimzi.api.kafka.model.CertSecretSourceFluentImpl<io.strimzi.api.kafka.model.ClientTlsFluent.TrustedCertificatesNested<N>> implements io.strimzi.api.kafka.model.ClientTlsFluent.TrustedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.CertSecretSourceBuilder builder;
        private final int index;

            TrustedCertificatesNestedImpl(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(this, item);
                        
            }

            TrustedCertificatesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) ClientTlsFluentImpl.this.setToTrustedCertificates(index,builder.build());
            }

            public N endTrustedCertificate() {
                return and();
            }
    }


}
