package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for environment variables for Strimzi containers.
   */
  public class ContainerEnvVarBuilder extends io.strimzi.api.kafka.model.ContainerEnvVarFluentImpl<io.strimzi.api.kafka.model.ContainerEnvVarBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.ContainerEnvVar,io.strimzi.api.kafka.model.ContainerEnvVarBuilder> {

    io.strimzi.api.kafka.model.ContainerEnvVarFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ContainerEnvVarBuilder() {
        this(true);
    }

    public ContainerEnvVarBuilder(java.lang.Boolean validationEnabled) {
        this(new ContainerEnvVar(), validationEnabled);
    }

    public ContainerEnvVarBuilder(io.strimzi.api.kafka.model.ContainerEnvVarFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerEnvVarBuilder(io.strimzi.api.kafka.model.ContainerEnvVarFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ContainerEnvVar(), validationEnabled);
    }

    public ContainerEnvVarBuilder(io.strimzi.api.kafka.model.ContainerEnvVarFluent<?> fluent,io.strimzi.api.kafka.model.ContainerEnvVar instance) {
        this(fluent, instance, true);
    }

    public ContainerEnvVarBuilder(io.strimzi.api.kafka.model.ContainerEnvVarFluent<?> fluent,io.strimzi.api.kafka.model.ContainerEnvVar instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withValue(instance.getValue());
        
        this.validationEnabled = validationEnabled; 
    }

    public ContainerEnvVarBuilder(io.strimzi.api.kafka.model.ContainerEnvVar instance) {
        this(instance,true);
    }

    public ContainerEnvVarBuilder(io.strimzi.api.kafka.model.ContainerEnvVar instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withValue(instance.getValue());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.ContainerEnvVar build() {
        ContainerEnvVar buildable = new ContainerEnvVar();
        buildable.setName(fluent.getName());
        buildable.setValue(fluent.getValue());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerEnvVarBuilder that = (ContainerEnvVarBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
